/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.composite;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.composite.RelocateListener;
import com.sun.faces.util.FacesLogger;
import jakarta.faces.application.Resource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.view.Location;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InsertChildrenHandler
extends TagHandlerImpl {
    private final Logger LOGGER = FacesLogger.TAGLIB.getLogger();
    private static final String REQUIRED_ATTRIBUTE = "required";
    public static final String INDEX_ATTRIBUTE = "InsertChildrenHandler.idx";
    private TagAttribute required = this.getAttribute("required");

    public InsertChildrenHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        UIComponent compositeParent = UIComponent.getCurrentCompositeComponent((FacesContext)ctx.getFacesContext());
        if (compositeParent != null) {
            int count = parent.getChildCount();
            compositeParent.subscribeToEvent(PostAddToViewEvent.class, (ComponentSystemEventListener)new RelocateChildrenListener(ctx, parent, count, this.tag.getLocation()));
        }
    }

    private class RelocateChildrenListener
    extends RelocateListener {
        private FaceletContext ctx;
        private UIComponent component;
        private int idx;
        private Location location;

        RelocateChildrenListener(FaceletContext ctx, UIComponent component, int idx, Location location) {
            this.ctx = ctx;
            this.component = component;
            if (!component.getAttributes().containsKey(InsertChildrenHandler.INDEX_ATTRIBUTE)) {
                component.getAttributes().put(InsertChildrenHandler.INDEX_ATTRIBUTE, idx);
            }
            this.idx = idx;
            this.location = location;
        }

        public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
            UIComponent compositeParent = event.getComponent();
            if (compositeParent == null) {
                return;
            }
            Resource resource = this.getBackingResource(compositeParent);
            while (compositeParent != null && !this.resourcesMatch(resource, this.location)) {
                if ((compositeParent = UIComponent.getCompositeComponentParent((UIComponent)compositeParent)) == null) continue;
                resource = this.getBackingResource(compositeParent);
            }
            if (compositeParent == null) {
                if (InsertChildrenHandler.this.LOGGER.isLoggable(Level.WARNING)) {
                    InsertChildrenHandler.this.LOGGER.log(Level.WARNING, "faces.composite.component.insertchildren.missing.template", this.location.toString());
                }
                return;
            }
            if (compositeParent.getChildCount() == 0 && this.isRequired()) {
                this.throwRequiredException(this.ctx, compositeParent);
            }
            List compositeChildren = compositeParent.getChildren();
            List parentChildren = this.component.getChildren();
            for (UIComponent c : compositeChildren) {
                String key = (String)c.getAttributes().get("com.sun.faces.facelets.MARK_ID");
                String value = this.component.getId();
                if (key == null || value == null) continue;
                compositeParent.getAttributes().put(key, value);
            }
            if (parentChildren.size() < this.getIdx()) {
                parentChildren.addAll(compositeChildren);
            } else {
                parentChildren.addAll(this.getIdx(), compositeChildren);
            }
        }

        private int getIdx() {
            Integer idx = (Integer)this.component.getAttributes().get(InsertChildrenHandler.INDEX_ATTRIBUTE);
            return idx != null ? idx : this.idx;
        }

        private void throwRequiredException(FaceletContext ctx, UIComponent compositeParent) {
            throw new TagException(InsertChildrenHandler.this.tag, "Unable to find any children components nested within parent composite component with id '" + compositeParent.getClientId(ctx.getFacesContext()) + "'");
        }

        private boolean isRequired() {
            return InsertChildrenHandler.this.required != null && InsertChildrenHandler.this.required.getBoolean(this.ctx);
        }
    }
}

