/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.MenuRenderer;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UIParameter;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchExpressionHandler;
import jakarta.faces.component.search.SearchExpressionHint;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class HtmlBasicRenderer
extends Renderer {
    protected static final Logger logger = FacesLogger.RENDERKIT.getLogger();
    protected static final Param[] EMPTY_PARAMS = new Param[0];
    private static final Set<SearchExpressionHint> EXPRESSION_HINTS = EnumSet.of(SearchExpressionHint.IGNORE_NO_RESULT, SearchExpressionHint.RESOLVE_SINGLE_COMPONENT);

    public String convertClientId(FacesContext context, String clientId) {
        return clientId;
    }

    public void decode(FacesContext context, UIComponent component) {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldDecode(component)) {
            return;
        }
        String clientId = this.decodeBehaviors(context, component);
        if (!(component instanceof UIInput)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "No decoding necessary since the component {0} is not an instance or a sub class of UIInput", component.getId());
            }
            return;
        }
        if (clientId == null) {
            clientId = component.getClientId(context);
        }
        assert (clientId != null);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestMap.get(clientId);
        if (newValue != null) {
            this.setSubmittedValue(component, newValue);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "new value after decoding {0}", newValue);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String currentValue = this.getCurrentValue(context, component);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Value to be rendered {0}", currentValue);
        }
        this.getEndTextToRender(context, component, currentValue);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected final String decodeBehaviors(FacesContext context, UIComponent component) {
        List behaviorsForEvent;
        if (!(component instanceof ClientBehaviorHolder)) {
            return null;
        }
        ClientBehaviorHolder holder = (ClientBehaviorHolder)component;
        Map behaviors = holder.getClientBehaviors();
        if (behaviors.isEmpty()) {
            return null;
        }
        String behaviorEvent = RenderKitUtils.PredefinedPostbackParameter.BEHAVIOR_EVENT_PARAM.getValue(context);
        if (null != behaviorEvent && (behaviorsForEvent = (List)behaviors.get(behaviorEvent)) != null && behaviorsForEvent.size() > 0) {
            String clientId;
            String behaviorSource = RenderKitUtils.PredefinedPostbackParameter.BEHAVIOR_SOURCE_PARAM.getValue(context);
            if (this.isBehaviorSource(context, behaviorSource, clientId = component.getClientId())) {
                for (ClientBehavior behavior : behaviorsForEvent) {
                    behavior.decode(context, component);
                }
            }
            return clientId;
        }
        return null;
    }

    protected boolean isBehaviorSource(FacesContext ctx, String behaviorSourceId, String componentClientId) {
        return behaviorSourceId != null && behaviorSourceId.equals(componentClientId);
    }

    protected String augmentIdReference(String forValue, UIComponent fromComponent) {
        int idSuffix;
        String id;
        int forSuffix = ((String)forValue).lastIndexOf("j_id");
        if (forSuffix <= 0 && (id = fromComponent.getId()) != null && (idSuffix = id.lastIndexOf("j_id")) > 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Augmenting for attribute with " + id.substring(idSuffix) + " suffix from Id attribute");
            }
            forValue = (String)forValue + id.substring(idSuffix);
        }
        return forValue;
    }

    protected void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator<UIComponent> kids = this.getChildren(component);
            while (kids.hasNext()) {
                UIComponent kid = kids.next();
                this.encodeRecursive(context, kid);
            }
        }
        component.encodeEnd(context);
    }

    protected Iterator<UIComponent> getChildren(UIComponent component) {
        int childCount = component.getChildCount();
        if (childCount > 0) {
            return component.getChildren().iterator();
        }
        return Collections.emptyList().iterator();
    }

    protected String getCurrentValue(FacesContext context, UIComponent component) {
        Object submittedValue;
        if (component instanceof UIInput && (submittedValue = ((UIInput)component).getSubmittedValue()) != null) {
            return submittedValue.toString();
        }
        String currentValue = null;
        Object currentObj = this.getValue(component);
        currentValue = this.getFormattedValue(context, component, currentObj);
        return currentValue;
    }

    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
    }

    protected UIComponent getFacet(UIComponent component, String name) {
        UIComponent facet = null;
        if (component.getFacetCount() > 0 && (facet = component.getFacet(name)) != null && !facet.isRendered()) {
            facet = null;
        }
        return facet;
    }

    protected UIComponent getForComponent(FacesContext context, String forComponent, UIComponent component) {
        UIComponent result;
        block6: {
            if (forComponent == null || forComponent.length() == 0) {
                return null;
            }
            result = null;
            try {
                for (UIComponent currentParent = component; currentParent != null && (result = currentParent.findComponent(forComponent)) == null; currentParent = currentParent.getParent()) {
                }
                if (result == null) {
                    result = HtmlBasicRenderer.findUIComponentBelow((UIComponent)context.getViewRoot(), forComponent);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINEST)) break block6;
                logger.log(Level.FINEST, "Unable to find for component", e);
            }
        }
        if (result == null && logger.isLoggable(Level.WARNING)) {
            logger.warning(MessageUtils.getExceptionMessageString("com.sun.faces.COMPONENT_NOT_FOUND_IN_VIEW_WARNING", forComponent));
        }
        return result;
    }

    protected String getFormattedValue(FacesContext context, UIComponent component, Object currentValue, Converter converter) throws ConverterException {
        if (!(component instanceof ValueHolder)) {
            if (currentValue != null) {
                return currentValue.toString();
            }
            return null;
        }
        if (converter == null) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null) {
            if (currentValue == null) {
                return "";
            }
            if (currentValue instanceof String) {
                return (String)currentValue;
            }
            Class<?> converterType = currentValue.getClass();
            converter = Util.getConverterForClass(converterType, context);
            if (converter == null) {
                return currentValue.toString();
            }
        }
        return converter.getAsString(context, component, currentValue);
    }

    protected String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        return this.getFormattedValue(context, component, currentValue, null);
    }

    protected Iterator getMessageIter(FacesContext context, String forComponent, UIComponent component) {
        if (forComponent == null) {
            return context.getMessages();
        }
        if (forComponent.trim().isEmpty()) {
            return context.getMessages(null);
        }
        SearchExpressionHandler searchExpressionHandler = context.getApplication().getSearchExpressionHandler();
        String clientId = searchExpressionHandler.resolveClientId(SearchExpressionContext.createSearchExpressionContext((FacesContext)context, (UIComponent)component, EXPRESSION_HINTS, null), forComponent);
        if (clientId == null) {
            return Collections.emptyIterator();
        }
        return context.getMessages(clientId);
    }

    protected Param[] getParamList(UIComponent command) {
        if (command.getChildCount() > 0) {
            ArrayList<Param> parameterList = new ArrayList<Param>();
            for (UIComponent kid : command.getChildren()) {
                UIParameter uiParam;
                if (!(kid instanceof UIParameter) || (uiParam = (UIParameter)kid).isDisable()) continue;
                Object value = uiParam.getValue();
                Param param = new Param(uiParam.getName(), value == null ? null : value.toString());
                parameterList.add(param);
            }
            return parameterList.toArray(new Param[parameterList.size()]);
        }
        return EMPTY_PARAMS;
    }

    protected Collection<ClientBehaviorContext.Parameter> getBehaviorParameters(UIComponent command) {
        ArrayList<ClientBehaviorContext.Parameter> params = null;
        int childCount = command.getChildCount();
        if (childCount > 0) {
            for (UIComponent kid : command.getChildren()) {
                if (!(kid instanceof UIParameter)) continue;
                UIParameter uiParam = (UIParameter)kid;
                String name = uiParam.getName();
                Object value = uiParam.getValue();
                if (Util.isEmpty(name)) continue;
                if (params == null) {
                    params = new ArrayList<ClientBehaviorContext.Parameter>(childCount);
                }
                params.add(new ClientBehaviorContext.Parameter(name, value));
            }
        }
        return params == null ? Collections.emptyList() : params;
    }

    protected Object getValue(UIComponent component) {
        throw new UnsupportedOperationException();
    }

    protected void setSubmittedValue(UIComponent component, Object value) {
    }

    protected boolean shouldWriteIdAttribute(UIComponent component) {
        String id = component.getId();
        return null != id && (!id.startsWith("j_id") || component instanceof ClientBehaviorHolder && !((ClientBehaviorHolder)component).getClientBehaviors().isEmpty());
    }

    protected String writeIdAttributeIfNecessary(FacesContext context, ResponseWriter writer, UIComponent component) {
        String id;
        block3: {
            id = null;
            if (this.shouldWriteIdAttribute(component)) {
                try {
                    id = component.getClientId(context);
                    writer.writeAttribute("id", (Object)id, "id");
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block3;
                    logger.warning(MessageUtils.getExceptionMessageString("com.sun.faces.CANT_WRITE_ID_ATTRIBUTE", e.getMessage()));
                }
            }
        }
        return id;
    }

    protected void rendererParamsNotNull(FacesContext context, UIComponent component) {
        Util.notNull("context", context);
        Util.notNull("component", component);
    }

    protected boolean shouldEncode(UIComponent component) {
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "End encoding component {0} since rendered attribute is set to false", component.getId());
            }
            return false;
        }
        return true;
    }

    protected boolean shouldDecode(UIComponent component) {
        if (Util.componentIsDisabledOrReadonly(component)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "No decoding necessary since the component {0} is disabled or read-only", component.getId());
            }
            return false;
        }
        return true;
    }

    protected boolean shouldEncodeChildren(UIComponent component) {
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Children of component {0} will not be encoded since this component's rendered attribute is false", component.getId());
            }
            return false;
        }
        return true;
    }

    protected static Map<String, List<ClientBehavior>> getPassThruBehaviors(UIComponent component, String domEventName, String componentEventName) {
        if (!(component instanceof ClientBehaviorHolder)) {
            return null;
        }
        Map behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
        int size = behaviors.size();
        if (size == 1 || size == 2) {
            boolean hasDomBehavior = behaviors.containsKey(domEventName);
            boolean hasComponentBehavior = behaviors.containsKey(componentEventName);
            if (size == 1 && (hasDomBehavior || hasComponentBehavior) || size == 2 && hasDomBehavior && hasComponentBehavior) {
                return null;
            }
        }
        return behaviors;
    }

    private static UIComponent findUIComponentBelow(UIComponent startPoint, String forComponent) {
        UIComponent retComp = null;
        if (startPoint.getChildCount() > 0) {
            List children = startPoint.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                UIComponent comp = (UIComponent)children.get(i);
                if (comp instanceof NamingContainer) {
                    try {
                        retComp = comp.findComponent(forComponent);
                    }
                    catch (IllegalArgumentException iae) {
                        continue;
                    }
                }
                if (retComp == null && comp.getChildCount() > 0) {
                    retComp = HtmlBasicRenderer.findUIComponentBelow(comp, forComponent);
                }
                if (retComp != null) break;
            }
        }
        return retComp;
    }

    public static class Param {
        public String name;
        public String value;

        public Param(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class OptionComponentInfo {
        String disabledClass;
        String enabledClass;
        String selectedClass;
        String unselectedClass;
        boolean disabled;
        boolean hideNoSelection;

        public OptionComponentInfo(UIComponent component) {
            Map attributes = component.getAttributes();
            this.disabledClass = (String)attributes.get("disabledClass");
            this.enabledClass = (String)attributes.get("enabledClass");
            this.selectedClass = (String)attributes.get("selectedClass");
            this.unselectedClass = (String)attributes.get("unselectedClass");
            this.disabled = Util.componentIsDisabled(component);
            this.hideNoSelection = MenuRenderer.isHideNoSelection(component);
        }

        public String getDisabledClass() {
            return this.disabledClass;
        }

        public String getEnabledClass() {
            return this.enabledClass;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public boolean isHideNoSelection() {
            return this.hideNoSelection;
        }

        public String getSelectedClass() {
            return this.selectedClass;
        }

        public String getUnselectedClass() {
            return this.unselectedClass;
        }
    }
}

