/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mojarra.action;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import java.lang.annotation.Annotation;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mojarra.action.ActionHeaderParameter;
import org.eclipse.mojarra.action.ActionMappingMatch;
import org.eclipse.mojarra.action.ActionParameterProducer;
import org.eclipse.mojarra.action.ActionPathParameter;
import org.eclipse.mojarra.action.ActionQueryParameter;

@ApplicationScoped
public class DefaultActionParameterProducer
implements ActionParameterProducer {
    @Override
    public Object produce(FacesContext facesContext, ActionMappingMatch actionMappingMatch, Class<?> parameterType, Annotation[] parameterAnnotations) {
        ActionHeaderParameter header = this.getActionHeaderParameterAnnotation(parameterAnnotations);
        if (header != null) {
            return facesContext.getExternalContext().getRequestHeaderMap().get(header.value());
        }
        ActionPathParameter path = this.getActionPathParameterAnnotation(parameterAnnotations);
        if (path != null) {
            Pattern pattern = Pattern.compile(actionMappingMatch.getActionMapping());
            Matcher matcher = pattern.matcher(actionMappingMatch.getPathInfo());
            if (matcher.matches()) {
                return matcher.group(path.value());
            }
            throw new FacesException("Unable to match @ActionPathParameter: " + path.value());
        }
        ActionQueryParameter query = this.getActionQueryParameterAnnotation(parameterAnnotations);
        if (query != null) {
            return facesContext.getExternalContext().getRequestParameterMap().get(query.value());
        }
        return CDI.current().select(parameterType, new Annotation[]{Any.Literal.INSTANCE}).get();
    }

    private ActionHeaderParameter getActionHeaderParameterAnnotation(Annotation[] annotations) {
        ActionHeaderParameter result = null;
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof ActionHeaderParameter)) continue;
                result = (ActionHeaderParameter)annotation;
                break;
            }
        }
        return result;
    }

    private ActionPathParameter getActionPathParameterAnnotation(Annotation[] annotations) {
        ActionPathParameter result = null;
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof ActionPathParameter)) continue;
                result = (ActionPathParameter)annotation;
                break;
            }
        }
        return result;
    }

    private ActionQueryParameter getActionQueryParameterAnnotation(Annotation[] annotations) {
        ActionQueryParameter result = null;
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof ActionQueryParameter)) continue;
                result = (ActionQueryParameter)annotation;
                break;
            }
        }
        return result;
    }
}

