/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mojarra.cdi;

import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CdiRenderKitFactory
extends RenderKitFactory {
    public BeanManager beanManager;

    public CdiRenderKitFactory() {
    }

    public CdiRenderKitFactory(RenderKitFactory wrapped) {
        super(wrapped);
        InitialContext initialContext2;
        try {
            initialContext2 = new InitialContext();
            this.beanManager = (BeanManager)initialContext2.lookup("java:comp/BeanManager");
        }
        catch (NamingException initialContext2) {
            // empty catch block
        }
        if (this.beanManager == null) {
            try {
                initialContext2 = new InitialContext();
                this.beanManager = (BeanManager)initialContext2.lookup("java:comp/env/BeanManager");
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    public void addRenderKit(String renderKitId, RenderKit renderKit) {
    }

    public RenderKit getRenderKit(FacesContext facesContext, String renderKitId) {
        RenderKit result = null;
        if (renderKitId.equals("HTML_BASIC")) {
            result = this.getWrapped().getRenderKit(facesContext, renderKitId);
        } else {
            AnnotatedType type = this.beanManager.createAnnotatedType(RenderKit.class);
            Set beans = this.beanManager.getBeans(type.getBaseType(), new Annotation[]{NamedLiteral.of((String)renderKitId)});
            for (Bean bean : beans) {
                Named named = bean.getBeanClass().getAnnotation(Named.class);
                if (!named.value().equals(renderKitId)) continue;
                result = (RenderKit)CDI.current().select(new Annotation[]{named}).get();
                break;
            }
        }
        return result;
    }

    public Iterator<String> getRenderKitIds() {
        ArrayList<String> renderKitIds = new ArrayList<String>();
        this.getWrapped().getRenderKitIds().forEachRemaining(renderKitIds::add);
        AnnotatedType type = this.beanManager.createAnnotatedType(RenderKit.class);
        Set beans = this.beanManager.getBeans(type.getBaseType(), new Annotation[0]);
        for (Bean bean : beans) {
            if (!bean.getBeanClass().isAnnotationPresent(Named.class)) continue;
            Named named = bean.getBeanClass().getAnnotation(Named.class);
            renderKitIds.add(named.value());
        }
        return renderKitIds.iterator();
    }
}

