/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mojarra.rest;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseListener;
import jakarta.faces.lifecycle.Lifecycle;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import org.eclipse.mojarra.rest.RestMappingMatch;
import org.eclipse.mojarra.rest.RestMappingMatcher;
import org.eclipse.mojarra.rest.RestMethodExecutor;
import org.eclipse.mojarra.rest.RestResponseMatcher;

@ApplicationScoped
@Named(value="org.eclipse.mojarra.rest.RestLifecycle")
public class RestLifecycle
extends Lifecycle {
    @Inject
    private RestMappingMatcher restMappingMatcher;
    @Inject
    private RestMethodExecutor restMethodExecutor;
    @Inject
    private RestResponseMatcher restResponseMatcher;

    public void addPhaseListener(PhaseListener phaseListener) {
    }

    public void execute(FacesContext facesContext) throws FacesException {
        RestMappingMatch match = this.restMappingMatcher.match(facesContext);
        if (match != null) {
            Object result = this.restMethodExecutor.execute(facesContext, match);
            facesContext.getAttributes().put(RestLifecycle.class.getPackage().getName() + ".RestResult", result);
        } else {
            try {
                facesContext.getExternalContext().responseSendError(404, "Unable to match request");
                facesContext.responseComplete();
            }
            catch (IOException ioe) {
                throw new FacesException((Throwable)ioe);
            }
        }
    }

    public PhaseListener[] getPhaseListeners() {
        return new PhaseListener[0];
    }

    public void removePhaseListener(PhaseListener phaseListener) {
    }

    public void render(FacesContext facesContext) throws FacesException {
        if (!facesContext.getResponseComplete()) {
            ExternalContext externalContext = facesContext.getExternalContext();
            String responseContentType = externalContext.getResponseContentType();
            if (responseContentType == null) {
                externalContext.setResponseContentType("application/json");
                responseContentType = "application/json";
            }
            this.restResponseMatcher.getResponseWriter(responseContentType).writeResponse(facesContext);
        }
    }
}

