/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mojarra.rest;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.mojarra.rest.RestLifecycle;
import org.eclipse.mojarra.rest.RestResponseWriter;
import org.eclipse.mojarra.rest.RestResponseWriterContentType;

@ApplicationScoped
@RestResponseWriterContentType(value="application/json")
public class DefaultJsonResponseWriter
implements RestResponseWriter {
    private final JsonbBuilder jsonbBuilder = JsonbBuilder.newBuilder();
    private final Jsonb jsonb = this.jsonbBuilder.build();

    @Override
    public void writeResponse(FacesContext facesContext) {
        Object result = facesContext.getAttributes().get(RestLifecycle.class.getPackage().getName() + ".RestResult");
        if (result == null) {
            try {
                facesContext.getExternalContext().responseSendError(204, "No content");
                facesContext.responseComplete();
            }
            catch (IOException ioe) {
                throw new FacesException((Throwable)ioe);
            }
        }
        try {
            Writer writer = facesContext.getExternalContext().getResponseOutputWriter();
            writer.write(this.jsonb.toJson(result));
            writer.flush();
            facesContext.responseComplete();
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }
}

