/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mojarra.rest;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import java.lang.annotation.Annotation;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mojarra.rest.RestHeaderParameter;
import org.eclipse.mojarra.rest.RestMappingMatch;
import org.eclipse.mojarra.rest.RestParameterProducer;
import org.eclipse.mojarra.rest.RestPathParameter;
import org.eclipse.mojarra.rest.RestQueryParameter;

@ApplicationScoped
public class DefaultRestParameterProducer
implements RestParameterProducer {
    @Override
    public Object produce(FacesContext facesContext, RestMappingMatch restMappingMatch, Class<?> parameterType, Annotation[] parameterAnnotations) {
        RestHeaderParameter header = this.getRestHeaderParameterAnnotation(parameterAnnotations);
        if (header != null) {
            String[] value = (String[])facesContext.getExternalContext().getRequestHeaderValuesMap().get(header.value());
            return value != null ? value : new String[]{};
        }
        RestPathParameter path = this.getRestPathParameterAnnotation(parameterAnnotations);
        if (path != null) {
            Pattern pattern = Pattern.compile(restMappingMatch.getRestPath());
            Matcher matcher = pattern.matcher(restMappingMatch.getPathInfo());
            if (matcher.matches()) {
                return matcher.group(path.value());
            }
            throw new FacesException("Unable to match @RestPathParameter: " + path.value());
        }
        RestQueryParameter query = this.getRestQueryParameterAnnotation(parameterAnnotations);
        if (query != null) {
            return facesContext.getExternalContext().getRequestParameterMap().get(query.value());
        }
        return CDI.current().select(parameterType, new Annotation[]{Any.Literal.INSTANCE}).get();
    }

    private RestHeaderParameter getRestHeaderParameterAnnotation(Annotation[] annotations) {
        RestHeaderParameter result = null;
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof RestHeaderParameter)) continue;
                result = (RestHeaderParameter)annotation;
                break;
            }
        }
        return result;
    }

    private RestPathParameter getRestPathParameterAnnotation(Annotation[] annotations) {
        RestPathParameter result = null;
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof RestPathParameter)) continue;
                result = (RestPathParameter)annotation;
                break;
            }
        }
        return result;
    }

    private RestQueryParameter getRestQueryParameterAnnotation(Annotation[] annotations) {
        RestQueryParameter result = null;
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof RestQueryParameter)) continue;
                result = (RestQueryParameter)annotation;
                break;
            }
        }
        return result;
    }
}

