/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.builders;

import cz.xtf.builder.builders.AbstractBuilder;
import cz.xtf.builder.builders.ApplicationBuilder;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteSpecBuilder;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import io.fabric8.openshift.api.model.TLSConfigBuilder;
import org.apache.commons.lang3.StringUtils;

public class RouteBuilder
extends AbstractBuilder<Route, RouteBuilder> {
    private String hostName;
    private String serviceName;
    private String routeKey;
    private String routeCertificate;
    private String routeCA;
    private String serverCA;
    private TLSType tlsType = TLSType.NONE;
    private int targetPort = 0;

    public RouteBuilder(String routeName) {
        this(null, routeName);
    }

    RouteBuilder(ApplicationBuilder applicationBuilder, String routeName) {
        super(applicationBuilder, routeName);
    }

    public RouteBuilder forService(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public RouteBuilder exposedAsHost(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public RouteBuilder edge() {
        this.tlsType = TLSType.EDGE;
        return this;
    }

    public RouteBuilder passthrough() {
        this.tlsType = TLSType.PASSTHROUGH;
        return this;
    }

    public RouteBuilder reencrypt() {
        this.tlsType = TLSType.REENCRYPT;
        return this;
    }

    public RouteBuilder defaultRouteCA() {
        this.routeCA("authority");
        return this;
    }

    public RouteBuilder routeCA(String routeCA) {
        this.routeCA = routeCA;
        return this;
    }

    public RouteBuilder routeKey(String routeKey) {
        this.routeKey = routeKey;
        return this;
    }

    public RouteBuilder routeCertificate(String routeCertificate) {
        this.routeCertificate = routeCertificate;
        return this;
    }

    public RouteBuilder serverCA(String serverCA) {
        this.serverCA = serverCA;
        return this;
    }

    public RouteBuilder targetPort(int targetPort) {
        this.targetPort = targetPort;
        return this;
    }

    @Override
    public Route build() {
        RouteSpecBuilder spec = (RouteSpecBuilder)((RouteSpecFluent.ToNested)((RouteSpecFluent.ToNested)((RouteSpecBuilder)new RouteSpecBuilder().withHost(this.hostName)).withNewTo().withKind("Service")).withName(this.serviceName)).endTo();
        if (this.targetPort != 0) {
            ((RouteSpecFluent.PortNested)spec.withNewPort().withNewTargetPort(Integer.valueOf(this.targetPort))).endPort();
        }
        if (this.tlsType != TLSType.NONE) {
            TLSConfigBuilder tls = (TLSConfigBuilder)new TLSConfigBuilder().withTermination(this.tlsType.toString().toLowerCase());
            if (StringUtils.isNotBlank((CharSequence)this.routeKey)) {
                tls.withKey(this.routeKey);
            }
            if (StringUtils.isNotBlank((CharSequence)this.routeCertificate)) {
                tls.withCertificate(this.routeCertificate);
            }
            if (StringUtils.isNotBlank((CharSequence)this.routeCA)) {
                tls.withCaCertificate(this.routeCA);
            }
            if (StringUtils.isNotBlank((CharSequence)this.serverCA)) {
                tls.withDestinationCACertificate(this.serverCA);
            }
            spec.withTls(tls.build());
        }
        return ((io.fabric8.openshift.api.model.RouteBuilder)((io.fabric8.openshift.api.model.RouteBuilder)new io.fabric8.openshift.api.model.RouteBuilder().withMetadata(this.metadataBuilder().build())).withSpec(spec.build())).build();
    }

    @Override
    protected RouteBuilder getThis() {
        return this;
    }

    private static enum TLSType {
        NONE,
        EDGE,
        PASSTHROUGH,
        REENCRYPT;

    }
}

