/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.builders;

import cz.xtf.builder.builders.AbstractBuilder;
import cz.xtf.builder.builders.ApplicationBuilder;
import cz.xtf.builder.builders.route.TransportProtocol;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceBuilder
extends AbstractBuilder<Service, ServiceBuilder> {
    private SessionAffinity sessionAffinity = SessionAffinity.None;
    private Map<String, String> selectors = new HashMap<String, String>();
    private String clusterIP = null;
    private List<ServicePort> servicePorts = new ArrayList<ServicePort>();
    private boolean isNodePort = false;
    private boolean isPublishNotReadyAddresses = false;

    public ServiceBuilder(String id) {
        this(null, id);
    }

    ServiceBuilder(ApplicationBuilder applicationBuilder, String id) {
        super(applicationBuilder, id);
    }

    public ServiceBuilder port(int targetPort) {
        return this.port(null, targetPort, targetPort, TransportProtocol.TCP);
    }

    public ServiceBuilder port(int targetPort, int port) {
        return this.port(null, targetPort, port, TransportProtocol.TCP);
    }

    public ServiceBuilder port(String name, int targetPort) {
        return this.port(name, targetPort, targetPort, TransportProtocol.TCP);
    }

    public ServiceBuilder port(String name, int targetPort, int port) {
        return this.port(name, targetPort, port, TransportProtocol.TCP);
    }

    public ServiceBuilder port(String name, int targetPort, int port, TransportProtocol protocol) {
        this.servicePorts.add(new ServicePort(name, targetPort, port, protocol));
        return this;
    }

    public ServiceBuilder ports(int ... targetPorts) {
        Arrays.stream(targetPorts).forEach(p -> this.port("port-" + p, p));
        return this;
    }

    public ServiceBuilder clientIPStickiness() {
        this.sessionAffinity = SessionAffinity.ClientIP;
        return this;
    }

    public ServiceBuilder noStickiness() {
        this.sessionAffinity = SessionAffinity.None;
        return this;
    }

    public ServiceBuilder addContainerSelector(String key, String value) {
        this.selectors.put(key, value);
        return this;
    }

    public ServiceBuilder headless() {
        this.clusterIP = "None";
        return this;
    }

    public ServiceBuilder nodePort() {
        this.isNodePort = true;
        return this;
    }

    public ServiceBuilder withoutSelectors() {
        this.selectors.clear();
        return this;
    }

    public ServiceBuilder withPublishNotReadyAddresses() {
        this.isPublishNotReadyAddresses = true;
        return this;
    }

    @Override
    public Service build() {
        ServiceSpecBuilder spec = new ServiceSpecBuilder();
        this.servicePorts.forEach(sp -> {
            ServiceSpecBuilder cfr_ignored_0 = (ServiceSpecBuilder)spec.addToPorts(new io.fabric8.kubernetes.api.model.ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(sp.getName())).withProtocol(sp.getTransportProtocol().uppercase())).withPort(Integer.valueOf(sp.getPort()))).withNewTargetPort(Integer.valueOf(sp.getTargetPort()))).build()});
        });
        spec.withSessionAffinity(this.sessionAffinity.toString());
        spec.withSelector(this.selectors);
        if (this.isPublishNotReadyAddresses) {
            spec.withPublishNotReadyAddresses(Boolean.valueOf(this.isPublishNotReadyAddresses));
        }
        if (this.clusterIP != null) {
            spec.withClusterIP(this.clusterIP);
        }
        if (this.isNodePort) {
            spec.withType("NodePort");
        }
        return ((io.fabric8.kubernetes.api.model.ServiceBuilder)((io.fabric8.kubernetes.api.model.ServiceBuilder)new io.fabric8.kubernetes.api.model.ServiceBuilder().withMetadata(this.metadataBuilder().build())).withSpec(spec.build())).build();
    }

    @Override
    protected ServiceBuilder getThis() {
        return this;
    }

    private static enum SessionAffinity {
        None,
        ClientIP;

    }

    private class ServicePort {
        private String name;
        private int targetPort;
        private int port;
        private TransportProtocol transportProtocol;

        public ServicePort(String name, int targetPort, int port, TransportProtocol transportProtocol) {
            this.name = name;
            this.targetPort = targetPort;
            this.port = port;
            this.transportProtocol = transportProtocol;
        }

        public String getName() {
            return this.name;
        }

        public int getTargetPort() {
            return this.targetPort;
        }

        public int getPort() {
            return this.port;
        }

        public TransportProtocol getTransportProtocol() {
            return this.transportProtocol;
        }
    }
}

