/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.builders;

import cz.xtf.builder.builders.AbstractBuilder;
import cz.xtf.builder.builders.ApplicationBuilder;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamSpecBuilder;
import io.fabric8.openshift.api.model.TagImportPolicy;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferenceBuilder;
import io.fabric8.openshift.api.model.TagReferenceFluent;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ImageStreamBuilder
extends AbstractBuilder<ImageStream, ImageStreamBuilder> {
    private static final boolean SCHEDULED = false;
    private final List<TagReference> tagReferences = new LinkedList<TagReference>();
    private String imageUrl;
    private boolean insecure = false;

    public ImageStreamBuilder(String name) {
        this(null, name);
    }

    ImageStreamBuilder(ApplicationBuilder applicationBuilder, String name) {
        super(applicationBuilder, name);
    }

    public ImageStreamBuilder fromExternalImage(String imageUrl) {
        String[] parts = imageUrl.split("/");
        String registry = "";
        String repo = "";
        String nameWithTag = "";
        switch (parts.length) {
            case 3: {
                registry = parts[0];
                repo = parts[1];
                nameWithTag = parts[2];
                break;
            }
            case 2: {
                repo = parts[0];
                nameWithTag = parts[1];
                break;
            }
            case 1: {
                nameWithTag = parts[0];
            }
        }
        String[] nameParts = nameWithTag.split(":");
        String name = nameParts[0];
        String tag = "";
        if (nameParts.length > 1) {
            tag = nameParts[1];
        }
        String remoteUri = (StringUtils.isNotBlank((CharSequence)registry) ? registry + "/" : "") + (StringUtils.isNotBlank((CharSequence)repo) ? repo + "/" : "") + name;
        this.remoteRepo(remoteUri);
        if (StringUtils.isNotBlank((CharSequence)tag)) {
            this.addTag(tag, imageUrl);
        }
        return this;
    }

    public ImageStreamBuilder remoteRepo(String imageUrl) {
        return this.remoteRepo(imageUrl, true);
    }

    public ImageStreamBuilder remoteRepo(String imageUrl, boolean insecure) {
        this.imageUrl = imageUrl;
        if (insecure) {
            return this.insecure();
        }
        return this;
    }

    public ImageStreamBuilder insecure() {
        this.insecure = true;
        this.addAnnotation("openshift.io/image.insecureRepository", "true");
        return this;
    }

    public ImageStreamBuilder addTag(String tag) {
        return this.addTag(tag, null);
    }

    public ImageStreamBuilder addTag(String tag, String sourceUrl) {
        return this.addTag(tag, sourceUrl, this.insecure);
    }

    public ImageStreamBuilder addTag(String tag, String sourceUrl, boolean insecure) {
        return this.addTag(tag, sourceUrl, insecure, TagReferencePolicyType.SOURCE);
    }

    public ImageStreamBuilder addTag(String tag, String sourceUrl, TagReferencePolicyType referencePolicyType) {
        return this.addTag(tag, sourceUrl, this.insecure, referencePolicyType);
    }

    public ImageStreamBuilder addTag(String tag, String sourceUrl, boolean insecure, TagReferencePolicyType referencePolicyType) {
        TagReferenceBuilder trb = (TagReferenceBuilder)new TagReferenceBuilder().withName(tag);
        if (StringUtils.isNotBlank((CharSequence)sourceUrl)) {
            trb.withImportPolicy(new TagImportPolicy(Boolean.valueOf(insecure), Boolean.valueOf(false)));
            ((TagReferenceFluent.FromNested)((TagReferenceFluent.FromNested)trb.withNewFrom().withKind("DockerImage")).withName(sourceUrl)).endFrom();
            trb.withNewReferencePolicy(referencePolicyType.toString());
        }
        this.tagReferences.add(trb.build());
        return this;
    }

    @Override
    public ImageStream build() {
        ImageStreamSpecBuilder builder = new ImageStreamSpecBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.imageUrl)) {
            builder.withDockerImageRepository(this.imageUrl);
        }
        builder.withTags(this.tagReferences);
        return ((io.fabric8.openshift.api.model.ImageStreamBuilder)((io.fabric8.openshift.api.model.ImageStreamBuilder)new io.fabric8.openshift.api.model.ImageStreamBuilder().withMetadata(this.metadataBuilder().build())).withSpec(builder.build())).build();
    }

    @Override
    protected ImageStreamBuilder getThis() {
        return this;
    }

    public static enum TagReferencePolicyType {
        LOCAL,
        SOURCE;


        public String toString() {
            return this.name().charAt(0) + (this.name().length() > 1 ? this.name().substring(1).toLowerCase() : "");
        }
    }
}

