/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.db;

import cz.xtf.builder.builders.pod.ContainerBuilder;
import cz.xtf.builder.builders.pod.PersistentVolumeClaim;
import cz.xtf.builder.db.AbstractSQLDatabase;
import cz.xtf.builder.db.ProbeSettings;
import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.image.Image;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShifts;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder;
import java.util.HashMap;
import java.util.Map;

public class OracleXE
extends AbstractSQLDatabase {
    private static final String ANYUID_SERVICE_ACCOUNT = "anyuid-sa";
    private static final Long USER_ID = 54321L;
    private static final String USERNAME = "system";
    private static final String PASSWORD = "oracle";
    private static final String DB_NAME = "XE";
    private static final String SYMBOLIC_NAME = "ORACLE";
    private static final String DATA_DIR = "/var/lib/oracle/data";

    public OracleXE() {
        super(USERNAME, PASSWORD, DB_NAME, SYMBOLIC_NAME, DATA_DIR);
    }

    public OracleXE(boolean withLivenessProbe, boolean withReadinessProbe) {
        super(USERNAME, PASSWORD, DB_NAME, SYMBOLIC_NAME, DATA_DIR, withLivenessProbe, withReadinessProbe);
    }

    public OracleXE(PersistentVolumeClaim pvc) {
        super(USERNAME, PASSWORD, DB_NAME, SYMBOLIC_NAME, DATA_DIR, pvc);
    }

    public OracleXE(PersistentVolumeClaim pvc, boolean withLivenessProbe, boolean withReadinessProbe) {
        super(USERNAME, PASSWORD, DB_NAME, SYMBOLIC_NAME, DATA_DIR, pvc, withLivenessProbe, withReadinessProbe);
    }

    public OracleXE(String username, String password, String dbName) {
        super(username, password, dbName, SYMBOLIC_NAME, DATA_DIR);
    }

    public OracleXE(String symbolicName, boolean withLivenessProbe, boolean withReadinessProbe) {
        super(USERNAME, PASSWORD, DB_NAME, symbolicName, DATA_DIR, withLivenessProbe, withReadinessProbe);
    }

    @Override
    protected void configureContainer(ContainerBuilder containerBuilder) {
        super.configureContainer(containerBuilder);
        OpenShift master = OpenShifts.master();
        if (master.getServiceAccount(ANYUID_SERVICE_ACCOUNT) == null) {
            master.createServiceAccount(((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder().withNewMetadata().withName(ANYUID_SERVICE_ACCOUNT)).endMetadata()).build());
        }
        OpenShift admin = OpenShifts.admin();
        ((Resource)admin.securityContextConstraints().withName("anyuid")).edit(new Visitor[]{new Visitor<SecurityContextConstraintsBuilder>(){

            public void visit(SecurityContextConstraintsBuilder builder) {
                builder.addToUsers(new String[]{"system:serviceaccount:" + OpenShiftConfig.namespace() + ":" + OracleXE.ANYUID_SERVICE_ACCOUNT});
            }
        }});
        containerBuilder.pod().addServiceAccount(ANYUID_SERVICE_ACCOUNT);
        containerBuilder.pod().addRunAsUserSecurityContext(USER_ID);
    }

    @Override
    protected ProbeSettings getProbeSettings() {
        return new ProbeSettings(30, String.valueOf(this.getPort()), 5, "/opt/oracle/checkDBStatus.sh", 5, "/opt/oracle/checkDBStatus.sh", 10, 10);
    }

    @Override
    protected String getJDBCConnectionStringPattern() {
        return "jdbc:oracle:thin:@%s:%s:%s";
    }

    @Override
    public String getImageName() {
        return Image.resolve((String)PASSWORD).getUrl();
    }

    @Override
    public Map<String, String> getImageVariables() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("ORACLE_PWD", this.getPassword());
        return vars;
    }

    @Override
    public int getPort() {
        return 1521;
    }
}

