/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.builders.pod;

import cz.xtf.builder.builders.EnvironmentConfiguration;
import cz.xtf.builder.builders.PodBuilder;
import cz.xtf.builder.builders.deployment.AbstractProbe;
import cz.xtf.builder.builders.deployment.Handler;
import cz.xtf.builder.builders.deployment.LivenessProbe;
import cz.xtf.builder.builders.deployment.ReadinessProbe;
import cz.xtf.builder.builders.deployment.StartupProbe;
import cz.xtf.builder.builders.limits.CPUResource;
import cz.xtf.builder.builders.limits.ComputingResource;
import cz.xtf.builder.builders.limits.MemoryResource;
import cz.xtf.builder.builders.limits.ResourceLimitBuilder;
import cz.xtf.builder.builders.pod.VolumeMount;
import cz.xtf.builder.builders.route.TransportProtocol;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelectorBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarSource;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.SecretKeySelectorBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ContainerBuilder
implements EnvironmentConfiguration,
ResourceLimitBuilder {
    private final PodBuilder pod;
    private final String name;
    private final Map<String, String> envVars = new HashMap<String, String>();
    private final List<String> args = new LinkedList<String>();
    private final Map<String, Entry> referredEnvVars = new HashMap<String, Entry>();
    private final Set<ContainerPort> ports = new HashSet<ContainerPort>();
    private final Set<VolumeMount> volumeMounts = new HashSet<VolumeMount>();
    private String imageName;
    private String imageNamespace;
    private boolean privileged = false;
    private AbstractProbe livenessProbe;
    private AbstractProbe readinessProbe;
    private StartupProbe startupProbe;
    private Handler preStopHandler;
    private String[] command;
    private Map<String, ComputingResource> computingResources = new HashMap<String, ComputingResource>();

    public ContainerBuilder(PodBuilder podBuilder, String name) {
        if (podBuilder == null) {
            throw new IllegalArgumentException("PodBuilder must not be null");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name must not be null nor empty");
        }
        this.pod = podBuilder;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ContainerBuilder fromImage(String imageName) {
        this.imageName = imageName;
        return this;
    }

    public ContainerBuilder fromImage(String imageNamespace, String imageName) {
        this.imageNamespace = imageNamespace;
        this.imageName = imageName;
        return this;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getImageNamespace() {
        return this.imageNamespace;
    }

    public ContainerBuilder port(int port) {
        return this.port(port, null, null);
    }

    public ContainerBuilder port(int port, String name) {
        return this.port(port, null, name);
    }

    public ContainerBuilder port(int port, TransportProtocol protocol, String name) {
        this.ports.add(new ContainerPort(port, protocol, name));
        return this;
    }

    public ContainerBuilder args(String value) {
        this.args.add(value);
        return this;
    }

    public ContainerBuilder envVar(String key, String value) {
        return this.configEntry(key, value);
    }

    public ContainerBuilder envVars(Map<String, String> vars) {
        return (ContainerBuilder)this.configEntries(vars);
    }

    public ContainerBuilder cleanEnvVars() {
        this.envVars.clear();
        return this;
    }

    public Map<String, String> getEnvVars() {
        return Collections.unmodifiableMap(this.envVars);
    }

    public ContainerBuilder privileged() {
        this.privileged = true;
        return this;
    }

    public ContainerBuilder addVolumeMount(String name, String mountPath, boolean readOnly) {
        this.volumeMounts.add(new VolumeMount(name, mountPath, readOnly));
        return this;
    }

    public ContainerBuilder addVolumeMount(String name, String mountPath, boolean readOnly, String subPath) {
        this.volumeMounts.add(new VolumeMount(name, mountPath, readOnly, subPath));
        return this;
    }

    public ContainerBuilder addVolumeMount(VolumeMount volumeMount) {
        this.volumeMounts.add(volumeMount);
        return this;
    }

    public LivenessProbe addLivenessProbe() {
        this.livenessProbe = new LivenessProbe();
        return (LivenessProbe)this.livenessProbe;
    }

    public ReadinessProbe addReadinessProbe() {
        this.readinessProbe = new ReadinessProbe();
        return (ReadinessProbe)this.readinessProbe;
    }

    public StartupProbe addStartupProbe() {
        this.startupProbe = new StartupProbe();
        return this.startupProbe;
    }

    public ContainerBuilder addReadinessProbe(AbstractProbe readinessProbe) {
        this.readinessProbe = readinessProbe;
        return this;
    }

    public ContainerBuilder addStartupProbe(StartupProbe startupProbe) {
        this.startupProbe = startupProbe;
        return this;
    }

    public ContainerBuilder addCommand(String ... cmd) {
        this.command = cmd;
        return this;
    }

    public PodBuilder pod() {
        return this.pod;
    }

    public Container build() {
        io.fabric8.kubernetes.api.model.ContainerBuilder builder = new io.fabric8.kubernetes.api.model.ContainerBuilder();
        Stream<EnvVar> definedVars = this.envVars.entrySet().stream().map(entry -> new EnvVar((String)entry.getKey(), (String)entry.getValue(), null));
        Stream<EnvVar> referredVars = this.referredEnvVars.entrySet().stream().map(entry -> entry instanceof ConfigMapEntry ? new EnvVar((String)entry.getKey(), null, new EnvVarSource(((ConfigMapKeySelectorBuilder)((ConfigMapKeySelectorBuilder)new ConfigMapKeySelectorBuilder().withKey(((Entry)entry.getValue()).getKey())).withName(((Entry)entry.getValue()).getValue())).build(), null, null, null)) : new EnvVar((String)entry.getKey(), null, new EnvVarSource(null, null, null, ((SecretKeySelectorBuilder)((SecretKeySelectorBuilder)new SecretKeySelectorBuilder().withKey(((Entry)entry.getValue()).getKey())).withName(((Entry)entry.getValue()).getValue())).build())));
        builder.withEnv(Stream.concat(definedVars, referredVars).collect(Collectors.toList()));
        builder.withImage(this.imageName);
        builder.withImagePullPolicy("Always");
        if (!this.args.isEmpty()) {
            builder.withArgs(this.args);
        }
        if (this.command != null) {
            builder.withCommand(this.command);
        }
        if (this.livenessProbe != null) {
            builder.withLivenessProbe(this.livenessProbe.build());
        }
        builder.withName(this.name);
        builder.withPorts(this.ports.stream().map(port -> {
            ContainerPortBuilder portBuilder = new ContainerPortBuilder();
            portBuilder.withContainerPort(Integer.valueOf(port.getContainerPort()));
            if (port.getProtocol() != null) {
                portBuilder.withProtocol(port.getProtocol().uppercase());
            }
            if (port.getName() != null) {
                portBuilder.withName(port.getName());
            }
            return portBuilder.build();
        }).collect(Collectors.toList()));
        if (this.preStopHandler != null) {
            ((ContainerFluent.LifecycleNested)builder.withNewLifecycle().withPreStop(this.preStopHandler.build())).endLifecycle();
        }
        if (this.privileged) {
            ((ContainerFluent.SecurityContextNested)builder.withNewSecurityContext().withPrivileged(Boolean.valueOf(true))).endSecurityContext();
        }
        if (this.readinessProbe != null) {
            builder.withReadinessProbe(this.readinessProbe.build());
        }
        if (this.startupProbe != null) {
            builder.withStartupProbe(this.startupProbe.build());
        }
        builder.withVolumeMounts(this.volumeMounts.stream().map(item -> ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(item.getName())).withMountPath(item.getMountPath())).withReadOnly(Boolean.valueOf(item.isReadOnly()))).withSubPath(item.getSubPath())).build()).collect(Collectors.toList()));
        List requests = this.computingResources.values().stream().filter(x -> x.getRequests() != null).collect(Collectors.toList());
        List limits = this.computingResources.values().stream().filter(x -> x.getLimits() != null).collect(Collectors.toList());
        if (!requests.isEmpty() || !limits.isEmpty()) {
            ContainerFluent.ResourcesNested resources = builder.withNewResources();
            if (!requests.isEmpty()) {
                resources.withRequests(requests.stream().collect(Collectors.toMap(ComputingResource::resourceIdentifier, x -> new Quantity(x.getRequests()))));
            }
            if (!limits.isEmpty()) {
                resources.withLimits(limits.stream().collect(Collectors.toMap(ComputingResource::resourceIdentifier, x -> new Quantity(x.getLimits()))));
            }
            resources.endResources();
        }
        return builder.build();
    }

    @Override
    public ComputingResource addCPUResource() {
        CPUResource r = new CPUResource();
        this.computingResources.put(((ComputingResource)r).resourceIdentifier(), r);
        return r;
    }

    @Override
    public ComputingResource addMemoryResource() {
        MemoryResource r = new MemoryResource();
        this.computingResources.put(((ComputingResource)r).resourceIdentifier(), r);
        return r;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ContainerBuilder that = (ContainerBuilder)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void addPreStopHandler(Handler handler) {
        this.preStopHandler = handler;
    }

    @Override
    public ContainerBuilder configEntry(String key, String value) {
        this.envVars.put(key, value);
        return this;
    }

    @Override
    public Map<String, String> getConfigEntries() {
        return this.envVars;
    }

    public ContainerBuilder configFromConfigMap(String configMapName, String ... configMapKeys) {
        return this.configFromConfigMap(configMapName, Arrays.asList(configMapKeys));
    }

    public ContainerBuilder configFromConfigMap(String configMapName, Collection<String> configMapKeys) {
        return this.configFromConfigMap(configMapName, Function.identity(), configMapKeys);
    }

    public ContainerBuilder configFromConfigMap(String configMapName, Function<String, String> nameMapping, String ... configMapKeys) {
        return this.configFromConfigMap(configMapName, nameMapping, Arrays.asList(configMapKeys));
    }

    public ContainerBuilder configFromConfigMap(String configMapName, Function<String, String> nameMapping, Collection<String> configMapKeys) {
        configMapKeys.forEach(x -> this.referredEnvVars.put((String)nameMapping.apply((String)x), new Entry((String)x, configMapName)));
        return this;
    }

    public ContainerBuilder configFromSecret(String secretName, Function<String, String> nameMapping, Collection<String> configMapKeys) {
        configMapKeys.forEach(x -> this.referredEnvVars.put((String)nameMapping.apply((String)x), new SecretEntry((String)x, secretName)));
        return this;
    }

    private static class ContainerPort {
        private final int containerPort;
        private final TransportProtocol protocol;
        private String name;

        public ContainerPort(int containerPort, TransportProtocol protocol, String name) {
            if (containerPort < 1 || containerPort > 65538) {
                throw new IllegalArgumentException("Wrong port number");
            }
            this.containerPort = containerPort;
            this.protocol = protocol;
            this.name = name;
        }

        public int getContainerPort() {
            return this.containerPort;
        }

        public TransportProtocol getProtocol() {
            return this.protocol;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContainerPort)) {
                return false;
            }
            ContainerPort that = (ContainerPort)o;
            if (this.containerPort != that.containerPort) {
                return false;
            }
            return this.protocol == that.protocol;
        }

        public int hashCode() {
            int result = this.containerPort;
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            return result;
        }
    }

    private class SecretEntry
    extends Entry {
        public SecretEntry(String x, String secretName) {
            super(x, secretName);
        }
    }

    private class Entry {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    private class ConfigMapEntry
    extends Entry {
        public ConfigMapEntry(String x, String configMapName) {
            super(x, configMapName);
        }
    }
}

