/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.builders;

import cz.xtf.builder.builders.AbstractBuilder;
import cz.xtf.builder.builders.ApplicationBuilder;
import cz.xtf.builder.builders.DeploymentConfigBuilder;
import cz.xtf.builder.builders.pod.ConfigMapVolume;
import cz.xtf.builder.builders.pod.ContainerBuilder;
import cz.xtf.builder.builders.pod.EmptyDirVolume;
import cz.xtf.builder.builders.pod.HostPathVolume;
import cz.xtf.builder.builders.pod.NFSVolume;
import cz.xtf.builder.builders.pod.PersistentVolumeClaim;
import cz.xtf.builder.builders.pod.SecretVolume;
import cz.xtf.builder.builders.pod.Volume;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PodBuilder
extends AbstractBuilder<Pod, PodBuilder> {
    private final DeploymentConfigBuilder deploymentBuilder;
    private final Set<Volume> volumes = new HashSet<Volume>();
    private final List<ContainerBuilder> containerBuilders = new ArrayList<ContainerBuilder>();
    private final List<ContainerBuilder> initContainerBuilders = new ArrayList<ContainerBuilder>();
    private final Map<String, String> nodeSelectorLabels = new HashMap<String, String>();
    private int gracefulShutdown = -1;
    private String serviceAccount;
    private Long runAsUser;

    public PodBuilder(String name) {
        this((DeploymentConfigBuilder)null, name);
    }

    PodBuilder(DeploymentConfigBuilder dcBuilder, String name) {
        super(PodBuilder.extractApplicationBuilder(dcBuilder), name);
        this.deploymentBuilder = dcBuilder;
        this.addLabel("name", name);
    }

    @Deprecated
    public ContainerBuilder container() {
        return this.container(this.getName());
    }

    public ContainerBuilder container(String name) {
        return this.getOrCreateContainerBuilder(name);
    }

    public ContainerBuilder initContainer(String name) {
        return this.getOrCreateInitContainerBuilder(name);
    }

    public Collection<ContainerBuilder> getContainers() {
        return Collections.unmodifiableList(this.containerBuilders);
    }

    public Collection<ContainerBuilder> getInitContainers() {
        return Collections.unmodifiableList(this.initContainerBuilders);
    }

    public PodBuilder gracefulShutdown(int seconds) {
        this.gracefulShutdown = seconds;
        return this;
    }

    public PodBuilder addHostPathVolume(String name, String sourceHostDirPath) {
        this.volumes.add(new HostPathVolume(name, sourceHostDirPath));
        return this;
    }

    public PodBuilder addSecretVolume(String name, String secretName) {
        this.volumes.add(new SecretVolume(name, secretName));
        return this;
    }

    public PodBuilder addSecretVolume(String name, String secretName, Map<String, String> items) {
        this.volumes.add(new SecretVolume(name, secretName, items));
        return this;
    }

    public PodBuilder addNFSVolume(String name, String server, String serverPath) {
        this.volumes.add(new NFSVolume(name, server, serverPath));
        return this;
    }

    public PodBuilder addEmptyDirVolume(String name) {
        this.volumes.add(new EmptyDirVolume(name));
        return this;
    }

    public PodBuilder addConfigMapVolume(String name, String configMapName) {
        this.volumes.add(new ConfigMapVolume(name, configMapName));
        return this;
    }

    public PodBuilder addConfigMapVolume(String name, String configMapName, String defaultMode) {
        this.volumes.add(new ConfigMapVolume(name, configMapName, defaultMode));
        return this;
    }

    public PodBuilder addPersistenVolumeClaim(String name, String claimName) {
        this.volumes.add(new PersistentVolumeClaim(name, claimName));
        return this;
    }

    public PodBuilder addServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return this;
    }

    public PodBuilder addRunAsUserSecurityContext(Long id) {
        this.runAsUser = id;
        return this;
    }

    public PodBuilder nodeSelector(String key, String value) {
        this.nodeSelectorLabels.put(key, value);
        return this;
    }

    @Override
    public Pod build() {
        PodSpecBuilder specBuilder = new PodSpecBuilder();
        specBuilder.withContainers(this.containerBuilders.stream().map(ContainerBuilder::build).collect(Collectors.toList()));
        specBuilder.withInitContainers(this.initContainerBuilders.stream().map(ContainerBuilder::build).collect(Collectors.toList()));
        specBuilder.withDnsPolicy("ClusterFirst");
        if (!this.nodeSelectorLabels.isEmpty()) {
            specBuilder.withNodeSelector(this.nodeSelectorLabels);
        }
        specBuilder.withRestartPolicy("Always");
        if (StringUtils.isNotBlank((CharSequence)this.serviceAccount)) {
            specBuilder.withServiceAccount(this.serviceAccount);
        }
        if (this.gracefulShutdown >= 0) {
            specBuilder.withTerminationGracePeriodSeconds(Long.valueOf(this.gracefulShutdown));
        }
        specBuilder.withVolumes(this.volumes.stream().map(Volume::build).collect(Collectors.toList()));
        if (this.runAsUser != null) {
            ((PodSpecFluent.SecurityContextNested)specBuilder.withNewSecurityContext().withRunAsUser(this.runAsUser)).endSecurityContext();
        }
        return ((io.fabric8.kubernetes.api.model.PodBuilder)((io.fabric8.kubernetes.api.model.PodBuilder)new io.fabric8.kubernetes.api.model.PodBuilder().withMetadata(this.metadataBuilder().build())).withSpec(specBuilder.build())).build();
    }

    public DeploymentConfigBuilder deployment() {
        if (this.deploymentBuilder == null) {
            throw new IllegalStateException("DeploymentConfigBuilder was not set in constructor");
        }
        return this.deploymentBuilder;
    }

    @Override
    protected PodBuilder getThis() {
        return this;
    }

    private ContainerBuilder getOrCreateContainerBuilder(String name) {
        return this.findOrCreateContainerBuilder(name, this.containerBuilders);
    }

    private ContainerBuilder getOrCreateInitContainerBuilder(String name) {
        return this.findOrCreateContainerBuilder(name, this.initContainerBuilders);
    }

    private ContainerBuilder findOrCreateContainerBuilder(String name, List<ContainerBuilder> containerList) {
        Optional<ContainerBuilder> opt = containerList.stream().filter(bldr -> bldr.getName().equals(name)).findFirst();
        if (opt.isPresent()) {
            return opt.get();
        }
        ContainerBuilder result = new ContainerBuilder(this, name);
        containerList.add(result);
        return result;
    }

    private static ApplicationBuilder extractApplicationBuilder(DeploymentConfigBuilder dcBuilder) {
        if (dcBuilder == null) {
            return null;
        }
        try {
            return dcBuilder.app();
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }
}

