/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.db;

import cz.xtf.builder.builders.pod.PersistentVolumeClaim;
import cz.xtf.builder.db.AbstractSQLDatabase;
import cz.xtf.builder.db.ProbeSettings;
import cz.xtf.core.image.Image;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DB2
extends AbstractSQLDatabase {
    private static final String DEFAULT_SYMBOLIC_NAME = "DB2";
    private static final String DEFAULT_DATA_DIR = "/database";
    private static final String DEFAULT_DB2_USER_ENV_VAR = "DB2INSTANCE";
    private static final String DEFAULT_DB2_PASS_ENV_VAR = "DB2INST1_PASSWORD";
    private static final String DEFAULT_DB2_DATABASE_ENV_VAR = "DBNAME";
    private Map<String, String> vars;
    private List<String> args;
    private String serviceAccount;

    public DB2(Builder builder) {
        super(builder.symbolicName, builder.dataDir, builder.pvc, builder.username, builder.password, builder.dbName, builder.configureEnvironment, builder.withLivenessProbe, builder.withReadinessProbe, builder.withStartupProbe, builder.deploymentConfigName, builder.envVarPrefix);
        this.vars = builder.vars;
        this.args = builder.args;
        this.serviceAccount = builder.serviceAccount;
    }

    @Override
    public String getImageName() {
        return Image.resolve((String)"db2").getUrl();
    }

    @Override
    public int getPort() {
        return 50000;
    }

    @Override
    protected ProbeSettings getProbeSettings() {
        return new ProbeSettings(120, String.valueOf(this.getPort()), 30, String.format("su - %s -c 'db2 -x \"connect to %s\" && db2 -x \"select 1 from sysibm.sysdummy1\"'", this.getUsername(), this.getDbName()), 5, 10, 10, 120, String.format("su - %s -c 'db2 -x connect to %s'", this.getUsername(), this.getDbName()), 10, 10);
    }

    @Override
    public Map<String, String> getImageVariables() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("LICENSE", "accept");
        vars.put(DEFAULT_DB2_DATABASE_ENV_VAR, this.getDbName());
        vars.put(DEFAULT_DB2_USER_ENV_VAR, this.getUsername());
        vars.put(DEFAULT_DB2_PASS_ENV_VAR, this.getPassword());
        vars.put("PERSISTENT_HOME", "false");
        vars.putAll(this.vars);
        return vars;
    }

    @Override
    public String toString() {
        return DEFAULT_SYMBOLIC_NAME;
    }

    @Override
    protected String getJDBCConnectionStringPattern() {
        return "jdbc:db2://%s:%s/%s";
    }

    @Override
    public List<String> getImageArgs() {
        return this.args;
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    boolean requiresPrivileged() {
        return true;
    }

    public static class Builder {
        private String symbolicName = "DB2";
        private String dataDir = "/database";
        private PersistentVolumeClaim pvc;
        private String username;
        private String password;
        private String dbName;
        private boolean configureEnvironment = true;
        private boolean withLivenessProbe;
        private boolean withReadinessProbe;
        private boolean withStartupProbe;
        private Map<String, String> vars = new HashMap<String, String>();
        private List<String> args;
        private String deploymentConfigName;
        private String envVarPrefix;
        private String serviceAccount;

        public Builder withArgs(List<String> args) {
            this.args = args;
            return this;
        }

        public Builder withConfigureEnvironment(boolean configureEnvironment) {
            this.configureEnvironment = configureEnvironment;
            return this;
        }

        public Builder withDataDir(String dataDir) {
            this.dataDir = dataDir;
            return this;
        }

        public Builder withDbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public Builder withDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public Builder withEnvVarPrefix(String envVarPrefix) {
            this.envVarPrefix = envVarPrefix;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withPvc(PersistentVolumeClaim pvc) {
            this.pvc = pvc;
            return this;
        }

        public Builder withSymbolicName(String symbolicName) {
            this.symbolicName = symbolicName;
            return this;
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withVars(Map<String, String> vars) {
            this.vars = vars;
            return this;
        }

        public Builder withWithLivenessProbe(boolean withLivenessProbe) {
            this.withLivenessProbe = withLivenessProbe;
            return this;
        }

        public Builder withWithReadinessProbe(boolean withReadinessProbe) {
            this.withReadinessProbe = withReadinessProbe;
            return this;
        }

        public Builder withWithStartupProbe(boolean withStartupProbe) {
            this.withStartupProbe = withStartupProbe;
            return this;
        }

        public Builder withServiceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        public DB2 build() {
            return new DB2(this);
        }
    }
}

