/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.builders.pod;

import cz.xtf.builder.builders.pod.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;

public class ConfigMapVolume
extends Volume {
    private final String configMapName;
    private final String defaultMode;

    public ConfigMapVolume(String name, String configMapName) {
        super(name);
        this.configMapName = configMapName;
        this.defaultMode = null;
    }

    public ConfigMapVolume(String name, String configMapName, String defaultMode) {
        super(name);
        this.configMapName = configMapName;
        this.defaultMode = defaultMode;
    }

    @Override
    protected void addVolumeParameters(VolumeBuilder builder) {
        VolumeFluent.ConfigMapNested cfm = builder.withNewConfigMap();
        cfm.withName(this.configMapName);
        if (this.defaultMode != null) {
            int defaultModeIntVal = 0;
            for (byte b : this.defaultMode.getBytes()) {
                int num = Character.getNumericValue(b);
                defaultModeIntVal = num | defaultModeIntVal << 3;
            }
            cfm.withDefaultMode(Integer.valueOf(defaultModeIntVal));
        }
        cfm.endConfigMap();
    }
}

