/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.builder.db;

import cz.xtf.builder.db.SQLExecutor;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;

public class SQLExecutorImpl
implements SQLExecutor {
    private final String connectionURL;
    private final String username;
    private final String password;

    public SQLExecutorImpl(String connectionURL, String username, String password) {
        this.connectionURL = connectionURL;
        this.username = username;
        this.password = password;
    }

    @Override
    public void executeSQL(Consumer<Connection> execute) {
        try {
            Connection db = DriverManager.getConnection(this.connectionURL, this.username, this.password);
            execute.accept(db);
            db.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void executeSQLFile(String resourceName) {
        this.executeSQL(db -> IOUtils.readLines((InputStream)SQLExecutorImpl.class.getResourceAsStream(resourceName)).forEach(x -> {
            try {
                db.createStatement().execute((String)x);
            }
            catch (SQLException e) {
                throw new IllegalArgumentException(e);
            }
        }));
    }
}

