/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.listeners;

import cz.xtf.core.config.OpenShiftConfig;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShifts;
import cz.xtf.core.waiting.SimpleWaiter;
import cz.xtf.junit5.config.JUnitConfig;
import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectCreator
implements TestExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(ProjectCreator.class);
    private static final OpenShift openShift = OpenShifts.master();

    public void testPlanExecutionStarted(TestPlan testPlan) {
        if (openShift.getProject() == null) {
            openShift.createProjectRequest();
            openShift.waiters().isProjectReady().waitFor();
            try {
                ((DoneableNamespace)((NamespaceFluent.MetadataNested)((DoneableNamespace)((Resource)OpenShifts.admin().namespaces().withName(openShift.getProject().getMetadata().getName())).edit()).editMetadata().addToLabels("xtf.cz/managed", "true")).endMetadata()).done();
            }
            catch (KubernetesClientException e) {
                log.warn("Couldn't assign label 'xtf.cz/managed' to the new project '" + openShift.getNamespace() + "'. Possible cause are insufficient permissions.");
                log.debug(e.getMessage());
            }
        }
        if (OpenShiftConfig.pullSecret() != null) {
            openShift.setupPullSecret(OpenShiftConfig.pullSecret());
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        boolean deleted;
        if (JUnitConfig.cleanOpenShift() && (deleted = openShift.deleteProject())) {
            BooleanSupplier bs = () -> openShift.getProject() == null;
            new SimpleWaiter(bs, TimeUnit.MINUTES, 2L, "Waiting for old project deletion").waitFor();
        }
    }
}

