/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.listeners;

import java.util.HashMap;
import java.util.Map;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestExecutionLogger
implements TestExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(TestExecutionLogger.class);
    private Map<String, Long> executionTimes = new HashMap<String, Long>();

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        String displayName = this.getTestDisplayName(testIdentifier);
        if (testIdentifier.isTest()) {
            log.info("*** {} is being skipped ***", (Object)displayName);
            log.info("*** {}: {} ***", (Object)displayName, (Object)reason);
        }
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            String displayName = this.getTestDisplayName(testIdentifier);
            this.executionTimes.put(testIdentifier.getUniqueId(), System.currentTimeMillis());
            log.info("*** {} is starting ***", (Object)displayName);
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testIdentifier.isTest()) {
            String displayName = this.getTestDisplayName(testIdentifier);
            long executionTime = System.currentTimeMillis() - this.executionTimes.remove(testIdentifier.getUniqueId());
            String status = this.resolveStatusString(testExecutionResult);
            log.info("*** {} {} after {}. ***", new Object[]{displayName, status, this.millisToString(executionTime)});
        }
    }

    private String resolveStatusString(TestExecutionResult testExecutionResult) {
        switch (testExecutionResult.getStatus()) {
            case SUCCESSFUL: {
                return "succeeded";
            }
            case FAILED: {
                return "failed";
            }
            case ABORTED: {
                return "has been aborted";
            }
        }
        return "is unknown";
    }

    private String getTestDisplayName(TestIdentifier testIdentifier) {
        String className = ((String)testIdentifier.getParentId().get()).replaceAll(".*class:", "").replaceAll("].*", "").replaceAll(".*\\.", "");
        return String.format("%s#%s", className, testIdentifier.getDisplayName());
    }

    private String millisToString(long millis) {
        long hours = millis / 3600000L;
        long minutes = millis % 3600000L / 60000L;
        long seconds = millis % 60000L / 1000L;
        long milis = millis % 1000L;
        return String.format("%s:%02d:%02d.%03d", hours, minutes, seconds, milis);
    }
}

