/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit5.extensions;

import cz.xtf.core.image.Image;
import cz.xtf.core.openshift.OpenShifts;
import cz.xtf.junit5.annotations.SinceVersion;
import cz.xtf.junit5.annotations.SinceVersions;
import cz.xtf.junit5.model.DockerImageMetadata;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class SinceVersionCondition
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        SinceVersion sinceVersion = AnnotationSupport.findAnnotation((Optional)context.getElement(), SinceVersion.class).orElse(null);
        SinceVersions sinceVersions = AnnotationSupport.findAnnotation((Optional)context.getElement(), SinceVersions.class).orElse(null);
        if (sinceVersion != null) {
            return SinceVersionCondition.resolve(sinceVersion);
        }
        if (sinceVersions != null) {
            for (SinceVersion sv : sinceVersions.value()) {
                ConditionEvaluationResult cer = SinceVersionCondition.resolve(sv);
                if (!cer.isDisabled()) continue;
                return cer;
            }
            return ConditionEvaluationResult.enabled((String)"Feature is expected to be available.");
        }
        return ConditionEvaluationResult.enabled((String)"SinceVersion annotation isn't present on target.");
    }

    public static ConditionEvaluationResult resolve(SinceVersion sinceVersion) {
        Matcher matcher;
        if (sinceVersion.name().equals("") == sinceVersion.imageMetadataLabelName().equals("")) {
            throw new RuntimeException("Only one of 'name' and 'imageMetadataLabelName' can be presented in 'SkipFor' annotation.");
        }
        Image image = Image.resolve((String)sinceVersion.image());
        if (!sinceVersion.name().equals("")) {
            matcher = Pattern.compile(sinceVersion.name()).matcher(image.getRepo());
        } else {
            DockerImageMetadata metadata = DockerImageMetadata.get(OpenShifts.master(), image);
            matcher = Pattern.compile(sinceVersion.imageMetadataLabelName()).matcher(metadata.labels().get("name"));
        }
        if (matcher.matches()) {
            if (image.isVersionAtLeast(sinceVersion.since())) {
                return ConditionEvaluationResult.enabled((String)("'" + image.getRepo() + "' image tag is equal or bigger then expected. Tested feature should be available."));
            }
            String jiraInfo = sinceVersion.jira().equals("") ? "" : " See " + sinceVersion.jira() + " for more info.";
            String message = "Tested feature isn't expected to be present in " + image.getRepo() + ":" + image.getTag() + "'. At least " + sinceVersion.since() + " tag is expected." + jiraInfo;
            return ConditionEvaluationResult.disabled((String)message);
        }
        return ConditionEvaluationResult.enabled((String)("Image '" + image.getRepo() + "' is expected to contain tested feature."));
    }
}

