/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api;

import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.AgroalDataSourceMetrics;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.function.Supplier;
import javax.sql.DataSource;

public interface AgroalDataSource
extends AutoCloseable,
DataSource,
Serializable {
    public static AgroalDataSource from(Supplier<AgroalDataSourceConfiguration> configurationSupplier, AgroalDataSourceListener ... listeners) throws SQLException {
        return AgroalDataSource.from(configurationSupplier.get(), listeners);
    }

    public static AgroalDataSource from(AgroalDataSourceConfiguration configuration, AgroalDataSourceListener ... listeners) throws SQLException {
        try {
            ClassLoader classLoader = AgroalDataSource.class.getClassLoader();
            Class<AgroalDataSource> dataSourceClass = classLoader.loadClass(configuration.dataSourceImplementation().className()).asSubclass(AgroalDataSource.class);
            Constructor<AgroalDataSource> dataSourceConstructor = dataSourceClass.getConstructor(AgroalDataSourceConfiguration.class, AgroalDataSourceListener[].class);
            return dataSourceConstructor.newInstance(configuration, listeners);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SQLException("Could not load Data Source class", e);
        }
    }

    public AgroalDataSourceConfiguration getConfiguration();

    public AgroalDataSourceMetrics getMetrics();

    public void addListener(AgroalDataSourceListener var1);

    @Override
    public void close();
}

