/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.configuration;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.transaction.TransactionIntegration;
import java.sql.Connection;
import java.time.Duration;

public interface AgroalConnectionPoolConfiguration {
    public AgroalConnectionFactoryConfiguration connectionFactoryConfiguration();

    public ConnectionValidator connectionValidator();

    public TransactionIntegration transactionIntegration();

    public Duration leakTimeout();

    public Duration validationTimeout();

    public Duration reapTimeout();

    public int initialSize();

    public int minSize();

    public void setMinSize(int var1);

    public int maxSize();

    public void setMaxSize(int var1);

    public Duration acquisitionTimeout();

    public void setAcquisitionTimeout(Duration var1);

    public static interface ConnectionValidator {
        public static ConnectionValidator defaultValidator() {
            return new ConnectionValidator(){

                @Override
                public boolean isValid(Connection connection) {
                    try {
                        return connection.isValid(0);
                    }
                    catch (Exception t) {
                        return false;
                    }
                }
            };
        }

        public static ConnectionValidator emptyValidator() {
            return new ConnectionValidator(){

                @Override
                public boolean isValid(Connection connection) {
                    return true;
                }
            };
        }

        public boolean isValid(Connection var1);
    }
}

