/*
 * Decompiled with CFR 0.152.
 */
package io.escalante.util;

import io.escalante.logging.Log;
import io.escalante.logging.Log$class;
import io.escalante.util.Closeable$;
import io.escalante.util.FileSystem$;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.jar.JarFile;
import org.jboss.logging.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileSystem$
implements Log,
ScalaObject {
    public static final FileSystem$ MODULE$;
    private final Logger io$escalante$logging$Log$$log;
    public volatile int bitmap$0;

    static {
        new FileSystem$();
    }

    public File mkDirs(File parent, String child) {
        return this.mkDirs(parent, child, false);
    }

    public File mkDirs(File parent, String child, boolean deleteIfPresent) {
        File f = new File(parent, child);
        if (deleteIfPresent & f.exists()) {
            this.deleteDirectory(f);
        }
        f.mkdirs();
        return f;
    }

    public File getTarget(Class<?> clazz) {
        File exceptionResult1 = null;
        try {
            exceptionResult1 = new File(new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent());
            return exceptionResult1;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Could not obtain the target URI", uRISyntaxException);
        }
    }

    public void copy(String srcPath, String destPath) {
        this.copy(new File(srcPath), new File(destPath));
    }

    public void copy(File src$1, File dest$1) {
        if (src$1.isDirectory()) {
            if (!dest$1.exists()) {
                dest$1.mkdir();
                this.debug((Function0<String>)new anonfun.copy.1(), src$1.getCanonicalPath(), (Object)dest$1.getCanonicalPath());
            }
            JavaConversions$.MODULE$.asScalaIterator(JavaConversions$.MODULE$.asJavaIterator(Predef$.MODULE$.refArrayOps((Object[])src$1.list()).iterator())).foreach((Function1)new anonfun.copy.2(src$1, dest$1));
        } else {
            this.copy(new FileInputStream(src$1), new FileOutputStream(dest$1));
            this.debug((Function0<String>)new anonfun.copy.3(), src$1.getCanonicalPath(), (Object)dest$1.getCanonicalPath());
        }
    }

    public void copy(InputStream in, OutputStream out$1) {
        Closeable$.MODULE$.use(in, new anonfun.copy.4(out$1));
    }

    public void deleteDirectory(File directory) {
        if (directory.isDirectory() && directory.exists()) {
            Predef$.MODULE$.refArrayOps((Object[])directory.listFiles()).foreach((Function1)new anonfun.deleteDirectory.1());
            if (directory.delete()) {
                return;
            }
            throw new RuntimeException(Predef$.MODULE$.augmentString("Failed to delete directory: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{directory})));
        }
        throw new RuntimeException(Predef$.MODULE$.augmentString("Unable to delete directory: %s.  It is either not a directory or does not exist.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{directory})));
    }

    public void deleteDirectoryIfPresent(File directory) {
        if (directory.exists()) {
            this.deleteDirectory(directory);
        }
    }

    public void unzip(File file, File target$1) {
        JarFile zip$1 = new JarFile(file);
        JavaConversions$.MODULE$.enumerationAsScalaIterator(zip$1.entries()).foreach((Function1)new anonfun.unzip.1(target$1, zip$1));
    }

    public String fileToString(File file, String encoding) {
        FileInputStream inStream = new FileInputStream(file);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            boolean reading = true;
            while (reading) {
                int n = inStream.read();
                if (n == -1) {
                    reading = false;
                    continue;
                }
                outStream.write(n);
            }
            outStream.flush();
            return new String(outStream.toByteArray(), encoding);
        }
        finally {
            inStream.close();
        }
    }

    public void printToFile(File f, Function1<PrintWriter, BoxedUnit> op) {
        PrintWriter p = new PrintWriter(f);
        try {
            op.apply((Object)p);
            return;
        }
        finally {
            p.close();
        }
    }

    private FileSystem$() {
        MODULE$ = this;
        Log$class.$init$(this);
    }
}

