/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.http;

import io.fabric8.gateway.http.FabricHTTPGateway;
import io.fabric8.gateway.http.HTTPGatewayConfig;
import io.fabric8.utils.Systems;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.weld.environment.se.bindings.Parameters;
import org.jboss.weld.environment.se.events.ContainerInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final String DEFAULT_PORT = "8080";
    public static final String DEFAULT_INDEX_ENABLED = "true";
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    @Inject
    FabricHTTPGateway fabricHTTPGateway;
    @Inject
    @Parameters
    String[] args;
    @Inject
    HTTPGatewayConfig gatewayConfig;

    public void main(@Observes ContainerInitialized event) {
        String serviceName = Systems.getEnvVarOrSystemProperty((String)"HTTP_GATEWAY_SERVICE_ID", (String)"HTTP_GATEWAY_SERVICE_ID", (String)"FABRIC8HTTPGATEWAY").toUpperCase() + "_SERVICE_";
        String hostEnvVar = serviceName + "HOST";
        String portEnvVar = serviceName + "PORT";
        this.gatewayConfig.put("HOST", Systems.getEnvVarOrSystemProperty((String)hostEnvVar, (String)hostEnvVar, (String)DEFAULT_HOST));
        this.gatewayConfig.put("PORT", Systems.getEnvVarOrSystemProperty((String)portEnvVar, (String)portEnvVar, (String)DEFAULT_PORT));
        this.gatewayConfig.put("ENABLE_INDEX", Systems.getEnvVarOrSystemProperty((String)portEnvVar, (String)portEnvVar, (String)DEFAULT_INDEX_ENABLED));
        try {
            this.fabricHTTPGateway.activate(this.gatewayConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Main.waitUntilStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void waitUntilStop() {
        Object lock = new Object();
        while (true) {
            Object object = lock;
            synchronized (object) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

