/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.template;

import io.fabric8.kubernetes.api.model.Env;
import io.fabric8.kubernetes.api.model.Port;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenerateTemplateDTO {
    protected String name;
    protected String dockerImage;
    protected String containerName;
    protected String template;
    protected Map<String, String> labels;
    protected List<Env> environmentVariables;
    protected List<Port> ports;
    protected Map<String, Object> templateVariables;
    private Integer replicaCount;

    public String getDockerImage() {
        return this.dockerImage;
    }

    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    public String getTemplate() {
        if (Strings.isNullOrBlank((String)this.template)) {
            this.template = "io/fabric8/templates/default.mvel";
        }
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public Map<String, Object> getTemplateVariables() {
        if (this.templateVariables == null) {
            this.templateVariables = new HashMap<String, Object>();
        }
        return this.templateVariables;
    }

    public void setTemplateVariables(Map<String, Object> templateVariables) {
        this.templateVariables = templateVariables;
    }

    public List<Env> getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            this.environmentVariables = new ArrayList<Env>();
        }
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(List<Env> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getReplicaCount() {
        if (this.replicaCount == null) {
            this.replicaCount = 1;
        }
        return this.replicaCount;
    }

    public void setReplicaCount(Integer replicaCount) {
        this.replicaCount = replicaCount;
    }

    public String getContainerName() {
        if (Strings.isNullOrBlank((String)this.containerName) && Strings.isNotBlank((String)this.name)) {
            this.containerName = Strings.splitCamelCase((String)this.name, (String)"-").toLowerCase();
        }
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public Map<String, String> getLabels() {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public List<Port> getPorts() {
        if (this.ports == null) {
            this.ports = new ArrayList<Port>();
        }
        return this.ports;
    }

    public void setPorts(List<Port> ports) {
        this.ports = ports;
    }
}

