/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.template;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.template.CreateAppDTO;
import io.fabric8.kubernetes.template.TemplateGenerator;
import io.fabric8.kubernetes.template.TemplateManagerMXBean;
import io.fabric8.utils.Files;
import io.fabric8.utils.JMXUtils;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Zips;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateManager
implements TemplateManagerMXBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(TemplateManager.class);
    public static ObjectName OBJECT_NAME;
    public static ObjectName GIT_FACADE_OBJECT_NAME;
    private static ObjectMapper objectMapper;
    private MBeanServer mbeanServer;

    public void init() {
        JMXUtils.registerMBean((Object)this, (ObjectName)OBJECT_NAME);
    }

    public void destroy() {
        JMXUtils.unregisterMBean((ObjectName)OBJECT_NAME);
    }

    @Override
    public String createAppByJson(String json) throws Exception {
        CreateAppDTO dto = (CreateAppDTO)objectMapper.reader(CreateAppDTO.class).readValue(json);
        System.out.println("Generating App from data: " + dto);
        return this.createApp(dto);
    }

    public String createApp(CreateAppDTO dto) throws IOException, URISyntaxException, InstanceNotFoundException, ReflectionException, MBeanException {
        MBeanServer beanServer = this.getMBeanServer();
        Objects.notNull((Object)beanServer, (String)"MBeanServer");
        if (!beanServer.isRegistered(GIT_FACADE_OBJECT_NAME)) {
            throw new InstanceNotFoundException("No MBeab is available for: " + GIT_FACADE_OBJECT_NAME);
        }
        TemplateGenerator generator = new TemplateGenerator(dto);
        File tmpDir = File.createTempFile("createApp-", ".folder");
        tmpDir.delete();
        tmpDir.mkdirs();
        File jsonFile = new File(tmpDir, "kubernetes.json");
        generator.generate(jsonFile);
        String summary = dto.getSummaryMarkdown();
        String readMe = dto.getReadMeMarkdown();
        Files.writeToFile((File)new File(tmpDir, "Summary.md"), (byte[])summary.getBytes());
        Files.writeToFile((File)new File(tmpDir, "ReadMe.md"), (byte[])readMe.getBytes());
        File zip = File.createTempFile("createApp-", ".zip");
        Zips.createZipFile((Logger)LOG, (File)tmpDir, (File)zip);
        String fileName = zip.getAbsolutePath();
        String outputName = dto.getName() + ".zip";
        Object[] params = new Object[]{dto.getBranch(), dto.getPath(), true, fileName, outputName};
        String[] signature = new String[]{String.class.getName(), String.class.getName(), "boolean", String.class.getName(), String.class.getName()};
        System.out.println("About to invoke " + GIT_FACADE_OBJECT_NAME + " uploadFile" + Arrays.asList(params) + " signature" + Arrays.asList(signature));
        Object answer = beanServer.invoke(GIT_FACADE_OBJECT_NAME, "uploadFile", params, signature);
        if (answer != null) {
            return answer.toString();
        }
        return "";
    }

    public MBeanServer getMBeanServer() {
        if (this.mbeanServer == null) {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return this.mbeanServer;
    }

    public void setMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("io.fabric8:type=KubernetesTemplateManager");
        }
        catch (MalformedObjectNameException e) {
            // empty catch block
        }
        try {
            GIT_FACADE_OBJECT_NAME = new ObjectName("hawtio:type=GitFacade");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        objectMapper = KubernetesFactory.createObjectMapper();
    }
}

