/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.h2;

import io.nessus.common.AssertState;
import io.nessus.common.BasicConfig;
import io.nessus.common.Config;
import io.nessus.h2.AbstractDBMain;
import io.nessus.h2.DBServerOptions;
import io.nessus.h2.DBUtils;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.h2.tools.Server;
import org.slf4j.Logger;

public class DBServer
extends AbstractDBMain<BasicConfig, DBServerOptions> {
    public static void main(String ... args) throws Exception {
        URL cfgurl = DBServer.class.getResource("/dbconfig.json");
        new DBServer(cfgurl).start(args);
    }

    DBServer(URL cfgurl) throws IOException {
        super(cfgurl);
    }

    protected DBServerOptions createOptions() {
        return new DBServerOptions();
    }

    protected void doStart(DBServerOptions options) throws Exception {
        Connection con = this.getConnection();
        this.logInfo("***************************************************", new Object[0]);
        this.logInfo("Starting H2 {}", new Object[]{DBUtils.getH2Version(con)});
        this.logInfo("Version {}", new Object[]{DBServer.getVersionString()});
        this.logInfo("***************************************************", new Object[0]);
        this.logInfo();
        this.startServer(this.config);
    }

    static void initConfig(Logger log, Config config) {
        String value;
        String key;
        LinkedHashMap<String, String> mapping = new LinkedHashMap<String, String>();
        mapping.put("jdbcServerUrl", "JDBC_SERVER_URL");
        mapping.put("jdbcUrl", "JDBC_URL");
        mapping.put("jdbcUser", "JDBC_USER");
        mapping.put("jdbcPass", "JDBC_PASS");
        BiFunction<String, String, String> logval = (k, v) -> {
            if (v == null) {
                return null;
            }
            boolean ispw = k.toLowerCase().contains("pass");
            v = ispw && v.length() > 0 ? "*****" : v;
            return v;
        };
        for (Map.Entry en : mapping.entrySet()) {
            key = (String)en.getKey();
            value = System.getenv((String)en.getValue());
            if (value == null) continue;
            log.debug("Env {}: {}", en.getValue(), (Object)logval.apply(key, value));
            config.putParameter(key, (Object)value);
        }
        for (Map.Entry en : mapping.entrySet()) {
            key = (String)en.getKey();
            value = System.getProperty(key);
            if (value == null) continue;
            log.debug("Prop {}: {}", (Object)key, (Object)logval.apply(key, value));
            config.putParameter((String)en.getKey(), (Object)value);
        }
    }

    public Server startServer(Config config) throws Exception {
        String serverUrl = (String)config.getParameter("jdbcServerUrl", String.class);
        String jdbcUrl = (String)config.getParameter("jdbcUrl", String.class);
        AssertState.notNull((Object)serverUrl, (String)"Null jdbcServerUrl");
        AssertState.notNull((Object)jdbcUrl, (String)"Null jdbcUrl");
        AssertState.isTrue((Boolean)serverUrl.startsWith("jdbc:h2:tcp://"), (String)("Protocol not supported: " + serverUrl));
        URL url = new URL(serverUrl.replace("jdbc:h2:tcp://", "http://"));
        String host = url.getHost();
        String port = "" + url.getPort();
        String dbpath = url.getPath();
        String baseDir = jdbcUrl.substring(jdbcUrl.indexOf(47), jdbcUrl.indexOf(dbpath));
        AssertState.isTrue((Boolean)("localhost".equals(host) || "127.0.0.1".equals(host) ? 1 : 0), (String)("Host not supported: " + host));
        Server server = Server.createTcpServer((String[])new String[]{"-baseDir", baseDir, "-tcpPort", port, "-tcpAllowOthers"}).start();
        this.logInfo(String.format("H2 Server: jdbc:h2:%s%s", server.getURL(), dbpath), new Object[0]);
        return server;
    }
}

