/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.h2;

import io.nessus.common.BasicConfig;
import io.nessus.common.Config;
import io.nessus.common.service.BasicLogService;
import io.nessus.common.service.Service;
import io.nessus.common.testing.AbstractTest;
import io.nessus.h2.ConnectionFactory;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractDBTest<T extends Config>
extends AbstractTest<T> {
    private ConnectionFactory conFactory;

    @Before
    public void before() throws Exception {
        this.createConnection();
    }

    @After
    public void after() throws Exception {
        Connection con = this.getConnection();
        if (con != null) {
            con.close();
        }
    }

    protected T createConfig() throws IOException {
        URL cfgurl = ((Object)((Object)this)).getClass().getResource("/dbconfig.yaml");
        BasicConfig config = new BasicConfig(cfgurl);
        config.addService((Service)new BasicLogService());
        return (T)config;
    }

    protected final ConnectionFactory createConnectionFactory() {
        return new ConnectionFactory(this.getConfig());
    }

    protected ConnectionFactory getConnectionFactory() {
        if (this.conFactory == null) {
            this.conFactory = this.createConnectionFactory();
        }
        return this.conFactory;
    }

    protected Connection getConnection() throws SQLException {
        ConnectionFactory factory = this.getConnectionFactory();
        return factory.getConnection();
    }

    protected Connection createConnection() throws SQLException {
        ConnectionFactory factory = this.getConnectionFactory();
        return factory.createConnection();
    }
}

