/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.h2;

import io.nessus.common.AssertState;
import io.nessus.common.BasicConfig;
import io.nessus.common.Config;
import io.nessus.h2.ConnectionFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBUtils {
    private static Logger LOG = LoggerFactory.getLogger(DBUtils.class);

    public static String getH2Version(Connection con) throws SQLException {
        Statement stm = con.createStatement();
        ResultSet res = stm.executeQuery("select h2version()");
        return res.next() ? res.getString(1) : null;
    }

    public static boolean tableExists(Connection con, String tableName) throws SQLException {
        ResultSet res = con.getMetaData().getTables(null, null, tableName.toUpperCase(), null);
        return res.next();
    }

    public static void createDatabase(Connection con, String resource) throws SQLException, IOException {
        List<String> statements = DBUtils.parseStatements(resource);
        for (String sqlstm : statements) {
            Statement stm = con.createStatement();
            Throwable throwable = null;
            try {
                stm.execute(sqlstm);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stm == null) continue;
                if (throwable != null) {
                    try {
                        stm.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stm.close();
            }
        }
    }

    public static void primeDatabase(Connection con, String resource) throws SQLException, IOException {
        List<String> statements = DBUtils.parseStatements(resource);
        HashSet<String> emptyTables = new HashSet<String>();
        for (String sqlstm : statements) {
            String tname = DBUtils.getTableName(sqlstm);
            if (tname == null || emptyTables.contains(tname)) continue;
            PreparedStatement stm = con.prepareStatement("SELECT COUNT(*) FROM " + tname);
            Throwable throwable = null;
            try {
                ResultSet res = stm.executeQuery();
                AssertState.isTrue((Boolean)res.next());
                int count = res.getInt(1);
                if (count != 0) continue;
                emptyTables.add(tname);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stm == null) continue;
                if (throwable != null) {
                    try {
                        stm.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stm.close();
            }
        }
        for (String sqlstm : statements) {
            Statement stm = con.createStatement();
            Throwable throwable = null;
            try {
                String tname = DBUtils.getTableName(sqlstm);
                if (!emptyTables.contains(tname)) continue;
                stm.execute(sqlstm);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stm == null) continue;
                if (throwable != null) {
                    try {
                        stm.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                stm.close();
            }
        }
    }

    private static String getTableName(String sqlstm) {
        String upr = sqlstm.toUpperCase();
        String[] toks = upr.split(" ");
        AssertState.isTrue((Boolean)(upr.startsWith("INSERT INTO ") && toks.length > 2 ? 1 : 0), (String)("Unsupported statement: " + sqlstm));
        String tname = toks[2];
        return tname;
    }

    private static List<String> parseStatements(String resource) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream in = BasicConfig.class.getResourceAsStream("/" + resource);){
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            StringBuffer buffer = new StringBuffer();
            String line = br.readLine();
            boolean commentOn = false;
            while (line != null) {
                if (line.length() == 0 || line.startsWith("--")) {
                    line = br.readLine();
                    continue;
                }
                if (line.startsWith("/*")) {
                    line = br.readLine();
                    commentOn = true;
                    continue;
                }
                if (line.endsWith("*/")) {
                    line = br.readLine();
                    commentOn = false;
                    continue;
                }
                if (commentOn) {
                    line = br.readLine();
                    continue;
                }
                buffer.append(line);
                if (line.endsWith(";")) {
                    String stm = buffer.toString();
                    result.add(stm);
                    buffer = new StringBuffer();
                }
                line = br.readLine();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compactDatabase(Config config) throws SQLException {
        LOG.info("Compacting the database ...");
        ConnectionFactory factory = new ConnectionFactory(config);
        try (Connection con = factory.getConnection();){
            PreparedStatement stm = con.prepareStatement("SHUTDOWN COMPACT");
            stm.execute();
        }
        finally {
            factory.createConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void defragDatabase(Config config) throws SQLException {
        LOG.info("Defragmenting the database ...");
        ConnectionFactory factory = new ConnectionFactory(config);
        try (Connection con = factory.getConnection();){
            PreparedStatement stm = con.prepareStatement("SHUTDOWN DEFRAG");
            stm.execute();
        }
        finally {
            factory.createConnection();
        }
    }
}

