/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.h2;

import io.nessus.common.AssertState;
import io.nessus.common.Config;
import io.nessus.h2.AbstractH2Main;
import io.nessus.h2.DBUtils;
import io.nessus.h2.H2Config;
import io.nessus.h2.H2Options;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import org.h2.tools.Server;

public class H2Server
extends AbstractH2Main {
    public static void main(String ... args) throws Exception {
        URL cfgurl = H2Server.class.getResource("/h2config.yaml");
        new H2Server(new H2Config(cfgurl)).start(args);
    }

    H2Server(H2Config config) throws IOException {
        super(config);
    }

    protected H2Options createOptions() {
        return new H2Options();
    }

    protected void doStart(H2Options options) throws Exception {
        Connection con = this.getConnection();
        this.logInfo("***************************************************", new Object[0]);
        this.logInfo("Starting H2 {}", new Object[]{DBUtils.getH2Version(con)});
        this.logInfo("Version {}", new Object[]{H2Server.getVersionString()});
        this.logInfo("***************************************************", new Object[0]);
        this.logInfo();
        this.startServer(this.config);
    }

    public Server startServer(Config config) throws Exception {
        String serverUrl = (String)config.getParameter("jdbcServerUrl", String.class);
        String jdbcUrl = (String)config.getParameter("jdbcUrl", String.class);
        AssertState.notNull((Object)serverUrl, (String)"Null jdbcServerUrl");
        AssertState.notNull((Object)jdbcUrl, (String)"Null jdbcUrl");
        AssertState.isTrue((Boolean)jdbcUrl.startsWith("jdbc:h2:file:"), (String)("Invalid local jdbcUrl: " + jdbcUrl));
        AssertState.isTrue((Boolean)serverUrl.startsWith("jdbc:h2:tcp:"), (String)("Protocol not supported: " + serverUrl));
        String auxUrlSpec = serverUrl.replace("jdbc:h2:tcp:", "");
        if (auxUrlSpec.startsWith("//")) {
            auxUrlSpec = auxUrlSpec.substring(2);
        }
        URL auxUrl = new URL("http://" + auxUrlSpec);
        String host = auxUrl.getHost();
        String port = "" + auxUrl.getPort();
        String dbpath = auxUrl.getPath();
        AssertState.isTrue((Boolean)("localhost".equals(host) || "127.0.0.1".equals(host) ? 1 : 0), (String)("Host not supported: " + serverUrl));
        AssertState.isTrue((Boolean)(dbpath.length() > 0 ? 1 : 0), (String)("No database path: " + serverUrl));
        String baseDir = jdbcUrl.substring(jdbcUrl.indexOf(47), jdbcUrl.indexOf(dbpath));
        Server server = Server.createTcpServer((String[])new String[]{"-baseDir", baseDir, "-tcpPort", port, "-tcpAllowOthers"}).start();
        this.logInfo(String.format("H2 Server: jdbc:h2:%s%s", server.getURL(), dbpath), new Object[0]);
        return server;
    }
}

