/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.bitcoin;

import io.nessus.AbstractWallet;
import io.nessus.Blockchain;
import io.nessus.Wallet;
import io.nessus.bitcoin.BitcoinAddress;
import io.nessus.bitcoin.BitcoinBlockchain;
import io.nessus.utils.AssertState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;

public class BitcoinWallet
extends AbstractWallet
implements Wallet {
    public BitcoinWallet(BitcoinBlockchain blockchain, BitcoindRpcClient client) {
        super((Blockchain)blockchain, client);
    }

    public Wallet.Address createNewAddress(List<String> labels) {
        String lstr = this.concatLabels(labels);
        String rawAddr = this.client.getNewAddress(lstr, "legacy");
        AssertState.assertTrue((Boolean)this.isP2PKH(rawAddr), (String)("Not a P2PKH address: " + rawAddr));
        return this.fromRawAddress(rawAddr, labels);
    }

    public Wallet.Address fromRawAddress(String rawAddr, List<String> labels) {
        return new BitcoinAddress(this, rawAddr, labels);
    }

    public boolean isP2PKH(String addr) {
        return addr.startsWith("1") || addr.startsWith("m") || addr.startsWith("n");
    }

    public List<String> getLabels() {
        HashSet lbset = new HashSet();
        this.getRawLabels().forEach(lb -> lbset.addAll(this.splitLabels((String)lb).stream().filter(tok -> !"(change)".equals(tok)).collect(Collectors.toList())));
        List<String> result = lbset.stream().sorted().collect(Collectors.toList());
        return result;
    }

    public List<Wallet.Address> getAddresses() {
        ArrayList<Wallet.Address> results = new ArrayList<Wallet.Address>();
        List<String> labels = this.getRawLabels();
        labels.forEach(lb -> {
            Map addrs = (Map)this.query("getaddressesbylabel", new Object[]{lb});
            addrs.keySet().stream().filter(raw -> this.isP2PKH((String)raw)).forEach(raw -> {
                List split = this.splitLabels((String)lb);
                Wallet.Address addr = this.fromRawAddress((String)raw, split);
                results.add(addr);
            });
        });
        return results;
    }

    private List<String> getRawLabels() {
        Object labels = this.query("listlabels", new Object[0]);
        return (List)labels;
    }
}

