/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.bitcoin.demo;

import io.nessus.BlockchainFactory;
import io.nessus.UTXO;
import io.nessus.Wallet;
import io.nessus.bitcoin.BitcoinBlockchain;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wf.bitcoin.javabitcoindrpcclient.BitcoinJSONRPCClient;
import wf.bitcoin.javabitcoindrpcclient.BitcoindRpcClient;

public class ContentProviderMain {
    private static final Logger LOG = LoggerFactory.getLogger(ContentProviderMain.class);

    public static void main(String[] args) {
        int port = 8080;
        String host = "localhost";
        Undertow server = Undertow.builder().addHttpListener(port, host, (HttpHandler)new ContentHandler()).build();
        LOG.debug("starting on http://" + host + ":" + port);
        server.start();
    }

    static class ContentHandler
    implements HttpHandler {
        private final BitcoinBlockchain blockchain = (BitcoinBlockchain)BlockchainFactory.getBlockchain((URL)BitcoinJSONRPCClient.DEFAULT_JSONRPC_TESTNET_URL, BitcoinBlockchain.class);
        private final Wallet.Address address = (Wallet.Address)this.blockchain.getWallet().getAddresses().get(0);

        ContentHandler() {
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.getResponseHeaders().add(Headers.CONTENT_TYPE, "text/html");
            ByteBuffer content = null;
            String path = exchange.getRelativePath();
            if (path.startsWith("/images")) {
                content = this.imageContent(exchange);
            } else if (path.startsWith("/portal")) {
                content = this.pageContent(exchange);
            }
            if (content != null) {
                exchange.getResponseSender().send(content);
            }
        }

        private ByteBuffer pageContent(HttpServerExchange exchange) throws IOException {
            String path = exchange.getRelativePath();
            int step = 1;
            Deque param = (Deque)exchange.getQueryParameters().get("step");
            int n = step = param != null ? Integer.valueOf((String)param.getFirst()) : step;
            if (step == 3 || step == 4) {
                step = 3;
                Wallet wallet = this.blockchain.getWallet();
                List utxos = wallet.listUnspent(Arrays.asList(this.address));
                if (utxos.size() > 0) {
                    for (UTXO utxo : utxos) {
                        String txId = utxo.getTxId();
                        BitcoindRpcClient.Transaction tx = this.blockchain.getRpcClient().getTransaction(txId);
                        long received = tx.timeReceived().getTime();
                        long now = System.currentTimeMillis();
                        long secs = (now - received) / 1000L;
                        if (secs >= 30L) continue;
                        LOG.info(String.format("Allow full access for another %d sec", 30L - secs));
                        step = 4;
                        break;
                    }
                }
                if (step == 3) {
                    LOG.info(String.format("No UTXO for %s", this.address));
                }
            }
            String resource = String.format("%s-%02d.html", path, step);
            return this.getResource(resource);
        }

        private ByteBuffer imageContent(HttpServerExchange exchange) throws IOException {
            String path = exchange.getRelativePath();
            return this.getResource(path);
        }

        private ByteBuffer getResource(String resname) throws IOException {
            InputStream is = this.getClass().getResourceAsStream(resname);
            if (is == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[256];
            int len = is.read(bytes);
            while (len > 0) {
                baos.write(bytes, 0, len);
                len = is.read(bytes);
            }
            return ByteBuffer.wrap(baos.toByteArray());
        }
    }
}

