/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs;

import io.ipfs.multihash.Multihash;
import io.nessus.Blockchain;
import io.nessus.Wallet;
import io.nessus.ipfs.AHandle;
import io.nessus.ipfs.FHandle;
import io.nessus.ipfs.client.IPFSClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.List;

public interface ContentManager {
    public Blockchain getBlockchain();

    public IPFSClient getIPFSClient();

    public AHandle registerAddress(Wallet.Address var1) throws GeneralSecurityException, IOException;

    public AHandle findAddressRegistation(Wallet.Address var1, Long var2);

    public AHandle unregisterAddress(Wallet.Address var1);

    public FHandle addIpfsContent(Wallet.Address var1, Path var2, URL var3) throws IOException, GeneralSecurityException;

    public FHandle addIpfsContent(Wallet.Address var1, Path var2, InputStream var3) throws IOException, GeneralSecurityException;

    public FHandle addIpfsContent(Wallet.Address var1, Path var2) throws IOException, GeneralSecurityException;

    public FHandle getIpfsContent(Wallet.Address var1, Multihash var2, Path var3, Long var4) throws IOException, GeneralSecurityException;

    public List<FHandle> findIpfsContent(Wallet.Address var1, Long var2) throws IOException;

    public FHandle sendIpfsContent(Wallet.Address var1, Multihash var2, Wallet.Address var3, Long var4) throws IOException, GeneralSecurityException;

    public List<Multihash> unregisterIpfsContent(Wallet.Address var1, List<Multihash> var2) throws IOException;

    public InputStream getLocalContent(Wallet.Address var1, Path var2) throws IOException;

    public List<FHandle> findLocalContent(Wallet.Address var1) throws IOException;

    public FHandle findLocalContent(Wallet.Address var1, Path var2) throws IOException;

    public boolean removeLocalContent(Wallet.Address var1, Path var2) throws IOException;
}

