/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs;

import io.ipfs.multihash.Multihash;
import io.nessus.Wallet;
import io.nessus.ipfs.AbstractHandle;
import io.nessus.ipfs.CidPath;
import io.nessus.utils.AssertArgument;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FHandle
extends AbstractHandle {
    final FHandle parent;
    final Path path;
    final URL furl;
    final String secToken;
    final List<FHandle> children = new ArrayList<FHandle>();

    private FHandle(FHandle parent, Wallet.Address owner, CidPath cid, Path path, URL furl, String secToken, String txId, boolean available, boolean expired, int attempt, long elapsed) {
        super(owner, cid, txId, available, expired, attempt, elapsed);
        boolean urlBased = path != null && furl != null;
        AssertArgument.assertTrue((Boolean)(urlBased || cid != null ? 1 : 0), (String)"Neither url nor cid based");
        this.parent = parent;
        this.path = path;
        this.furl = furl;
        this.secToken = secToken;
    }

    public FHandle getRoot() {
        FHandle result = this;
        while (result.parent != null) {
            result = result.parent;
        }
        return result;
    }

    public FHandle getParent() {
        return this.parent;
    }

    public List<FHandle> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public FHandle findChild(Path path) {
        AssertArgument.assertNotNull((Object)path, (String)"Null path");
        return this.findChildRecursive(this.getRoot(), path);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public URL getURL() {
        return this.furl;
    }

    public Path getFilePath() {
        if (this.furl == null || !this.furl.getProtocol().equals("file")) {
            return null;
        }
        try {
            return Paths.get(URLDecoder.decode(this.furl.getPath(), "UTF-8"), new String[0]);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Path getPath() {
        return this.path;
    }

    public String getSecretToken() {
        return this.secToken;
    }

    public boolean isEncrypted() {
        return this.secToken != null;
    }

    private void addChild(FHandle fhchild) {
        Path chpath = fhchild.getPath();
        Multihash chcid = fhchild.getCid();
        AssertArgument.assertTrue((Boolean)(chcid != null || chpath != null ? 1 : 0), (String)("Neither cid not path in: " + fhchild));
        if (chpath != null) {
            AssertArgument.assertTrue((Boolean)(chpath.startsWith(this.path) && !chpath.equals(this.path) ? 1 : 0), (String)("Invalid child path: " + chpath));
            this.children.forEach(ch -> AssertArgument.assertTrue((Boolean)(!chpath.equals(ch.getPath()) ? 1 : 0), (String)("Duplicate child path: " + chpath)));
        }
        this.children.add(fhchild);
    }

    private FHandle findChildRecursive(FHandle fhandle, Path path) {
        if (path.equals(fhandle.path)) {
            return fhandle;
        }
        for (FHandle aux : fhandle.children) {
            FHandle auxRes = this.findChildRecursive(aux, path);
            if (auxRes == null) continue;
            return auxRes;
        }
        return null;
    }

    public String toString(boolean verbose) {
        if (!verbose) {
            return this.toString();
        }
        StringWriter sw = new StringWriter();
        this.recursiveString(new PrintWriter(sw), 0, this);
        return sw.toString().trim();
    }

    private void recursiveString(PrintWriter pw, int indent, FHandle fh) {
        char[] pad = new char[indent];
        Arrays.fill(pad, ' ');
        pw.println(new String(pad) + fh);
        if (fh.hasChildren()) {
            fh.children.forEach(ch -> this.recursiveString(pw, indent + 3, (FHandle)ch));
        }
    }

    public String toString() {
        String addr = this.owner.getAddress();
        return String.format("[addr=%s, cid=%s, path=%s, avl=%d, exp=%d, try=%d, time=%s]", addr, this.cid, this.path, this.available ? 1 : 0, this.expired ? 1 : 0, this.attempt, this.elapsed);
    }

    public static class FHBuilder
    extends AbstractHandle.AbstractBuilder<FHBuilder, FHandle> {
        private FHandle parent;
        private Path path;
        private URL furl;
        private String secToken;
        private boolean available;
        private FHBuilder parentBuilder;
        private Map<Path, FHBuilder> childBuilders = new LinkedHashMap<Path, FHBuilder>();

        public FHBuilder(FHandle fhandle) {
            super(fhandle);
            AssertArgument.assertTrue((Boolean)(fhandle.parent == null ? 1 : 0), (String)"Cannot rebuild partial trees");
            this.init(null, fhandle);
        }

        public FHBuilder(Wallet.Address owner, Path path, URL furl) {
            super(owner);
            AssertArgument.assertNotNull((Object)path, (String)"Null path");
            AssertArgument.assertNotNull((Object)furl, (String)"Null furl");
            this.path = path;
            this.furl = furl;
        }

        public FHBuilder(Wallet.Address owner, String txId, Multihash cid) {
            super(owner, txId, cid);
        }

        private FHBuilder(FHBuilder parentBuilder, FHandle fhandle) {
            super(fhandle);
            this.init(parentBuilder, fhandle);
        }

        private void init(FHBuilder parentBuilder, FHandle fhandle) {
            this.parentBuilder = parentBuilder;
            this.owner = fhandle.owner;
            this.cid = fhandle.cid;
            this.path = fhandle.path;
            this.furl = fhandle.furl;
            this.txId = fhandle.txId;
            this.secToken = fhandle.secToken;
            this.available = fhandle.available;
            this.expired = fhandle.expired;
            this.attempt = fhandle.attempt;
            this.elapsed = fhandle.elapsed;
            fhandle.children.forEach(ch -> {
                FHBuilder cbuilder = new FHBuilder(this, (FHandle)ch);
                this.childBuilders.put(ch.getPath(), cbuilder);
            });
        }

        public FHBuilder rootBuilder() {
            FHBuilder rootBuilder = this;
            while (rootBuilder.parentBuilder != null) {
                rootBuilder = rootBuilder.parentBuilder;
            }
            return rootBuilder;
        }

        public FHBuilder findChild(Path path) {
            AssertArgument.assertNotNull((Object)path, (String)"Null path");
            return this.findChildRecursive(this.rootBuilder(), path);
        }

        public FHBuilder findChild(Multihash cid) {
            AssertArgument.assertNotNull((Object)cid, (String)"Null cid");
            return this.findChildRecursive(this.rootBuilder(), new CidPath(cid));
        }

        FHBuilder findChildRecursive(FHBuilder builder, Path path) {
            if (path.equals(builder.path)) {
                return builder;
            }
            for (FHBuilder aux : builder.childBuilders.values()) {
                FHBuilder auxRes = this.findChildRecursive(aux, path);
                if (auxRes == null) continue;
                return auxRes;
            }
            return null;
        }

        FHBuilder findChildRecursive(FHBuilder builder, CidPath cid) {
            if (cid.equals(builder.cid)) {
                return builder;
            }
            for (FHBuilder aux : builder.childBuilders.values()) {
                FHBuilder auxRes = this.findChildRecursive(aux, cid);
                if (auxRes == null) continue;
                return auxRes;
            }
            return null;
        }

        public FHBuilder parent(FHandle parent) {
            this.parent = parent;
            return this;
        }

        public FHBuilder path(Path path) {
            this.path = path;
            return this;
        }

        public FHBuilder url(URL furl) {
            this.furl = furl;
            return this;
        }

        public FHBuilder secretToken(String secToken) {
            this.secToken = secToken;
            return this;
        }

        public FHBuilder available(boolean available) {
            this.available = available;
            return this;
        }

        @Override
        public FHandle build() {
            if (this.parentBuilder == null) {
                return this.buildInternal();
            }
            FHBuilder rootBuilder = this.rootBuilder();
            FHandle rootHandle = rootBuilder.buildInternal();
            FHandle childHandle = rootHandle.findChild(this.path);
            return childHandle;
        }

        private FHandle buildInternal() {
            FHandle rootHandle;
            Multihash rootCid;
            if (this.parent != null && (rootCid = (rootHandle = this.parent.getRoot()).getCid()) != null) {
                Path rootPath = rootHandle.getPath();
                Path relpath = rootPath.relativize(this.path);
                this.cid = new CidPath(rootCid, relpath);
            }
            FHandle fhandle = new FHandle(this.parent, this.owner, this.cid, this.path, this.furl, this.secToken, this.txId, this.available, this.expired, this.attempt, this.elapsed);
            this.childBuilders.values().stream().map(cb -> cb.parent(fhandle).buildInternal()).collect(Collectors.toList());
            if (this.parent != null) {
                this.parent.addChild(fhandle);
            }
            return fhandle;
        }
    }

    public static class FHWalker {
        public static FHandle walkTree(FHandle fhandle, Visitor visitor) throws IOException, GeneralSecurityException {
            FHandle fhroot = fhandle.getRoot();
            FHReference fhref = new FHReference(fhroot);
            FHWalker.walkTreeRecursive(fhref, fhroot.getPath(), visitor);
            return fhref.getFHandle();
        }

        private static boolean walkTreeRecursive(FHReference fhref, Path path, Visitor visitor) throws IOException, GeneralSecurityException {
            boolean success;
            block1: {
                FHandle aux;
                FHandle fhroot = fhref.getFHandle();
                FHandle fhchild = fhroot.findChild(path);
                FHandle fhres = visitor.visit(fhchild);
                boolean bl = success = fhres != null;
                if (!success) break block1;
                fhref.setFHandle(fhres.getRoot());
                Iterator<FHandle> iterator = fhres.getChildren().iterator();
                while (iterator.hasNext() && (success = FHWalker.walkTreeRecursive(fhref, (aux = iterator.next()).getPath(), visitor))) {
                }
            }
            return success;
        }

        public static interface Visitor {
            public FHandle visit(FHandle var1) throws IOException, GeneralSecurityException;
        }
    }

    public static class FHReference {
        private FHandle fhref;

        public FHReference() {
        }

        public FHReference(FHandle fh) {
            this.fhref = fh;
        }

        public synchronized FHandle getFHandle() {
            return this.fhref;
        }

        public synchronized void setFHandle(FHandle fh) {
            this.fhref = fh;
        }

        public synchronized String toString() {
            return this.fhref.toString();
        }
    }
}

