/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.core;

import io.ipfs.multihash.Multihash;
import io.nessus.Tx;
import io.nessus.TxOutput;
import io.nessus.UTXO;
import io.nessus.Wallet;
import io.nessus.ipfs.ContentManagerConfig;
import io.nessus.ipfs.FHandle;
import io.nessus.ipfs.client.IPFSClient;
import io.nessus.ipfs.client.IPFSException;
import io.nessus.ipfs.client.IPFSNotFoundException;
import io.nessus.ipfs.client.IPFSTimeoutException;
import io.nessus.ipfs.core.AbstractHandleManager;
import io.nessus.ipfs.core.DefaultContentManager;
import io.nessus.ipfs.core.FHeader;
import io.nessus.ipfs.core.FHeaderValues;
import io.nessus.ipfs.core.IPFSCache;
import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FHandleManager
extends AbstractHandleManager<FHandle> {
    FHandleManager(DefaultContentManager cntmgr) {
        super(cntmgr);
    }

    public FHandle addIpfsContent(FHandle fhandle, boolean dryRun) throws IOException {
        IPFSClient ipfsClient = this.cntmgr.getIPFSClient();
        Path auxPath = fhandle.getFilePath();
        AssertState.assertTrue((Boolean)auxPath.toFile().exists(), (String)("Encrypted content does not exists: " + auxPath));
        List cids = ipfsClient.add(auxPath, dryRun);
        AssertState.assertTrue((Boolean)(cids.size() > 0 ? 1 : 0), (String)"No ipfs content ids");
        Multihash cid = (Multihash)cids.get(cids.size() - 1);
        FHandle fhres = ((FHandle.FHBuilder)new FHandle.FHBuilder(fhandle).cid(cid)).build();
        return fhres;
    }

    public FHandle getIpfsContent(FHandle fhandle, long timeout) throws IOException, IPFSTimeoutException {
        AssertArgument.assertNotNull((Object)fhandle, (String)"Null fhandle");
        AssertArgument.assertNotNull((Object)fhandle.getOwner(), (String)"Null owner");
        AssertArgument.assertNotNull((Object)fhandle.getCid(), (String)"Null cid");
        Wallet.Address owner = fhandle.getOwner();
        Multihash cid = fhandle.getCid();
        IPFSCache ipfsCache = this.cntmgr.getIPFSCache();
        FHandle fhres = ipfsCache.get(cid, FHandle.class);
        if (fhres.isAvailable()) {
            return fhres;
        }
        int attempt = fhres.getAttempt();
        this.LOG.info("{}: {}", (Object)this.logPrefix("attempt", attempt), (Object)fhres);
        long before = System.currentTimeMillis();
        try {
            Path cryptPath = this.cntmgr.getCryptPath(owner);
            IPFSClient ipfsClient = this.cntmgr.getIPFSClient();
            Future future = ipfsClient.get(cid, cryptPath);
            Path resPath = (Path)future.get(timeout, TimeUnit.MILLISECONDS);
            URL furl = resPath.toUri().toURL();
            fhres = new FHandle.FHBuilder(fhres).url(furl).build();
            File rootFile = fhres.getFilePath().toFile();
            AssertState.assertTrue((Boolean)rootFile.exists(), (String)("Cannot find IPFS content at: " + rootFile));
            fhres = rootFile.isDirectory() ? this.createFHandleTree(fhres) : this.createFromFileHeader(null, fhres);
            fhres = new FHandle.FHBuilder(fhres).available(true).build();
        }
        catch (InterruptedException | ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IPFSException) {
                throw (IPFSException)cause;
            }
            throw new IPFSException((Throwable)ex);
        }
        catch (TimeoutException ex) {
            throw new IPFSTimeoutException((Throwable)ex);
        }
        finally {
            long elapsed = System.currentTimeMillis() - before;
            fhres = ((FHandle.FHBuilder)((FHandle.FHBuilder)new FHandle.FHBuilder(fhres).elapsed(fhres.getElapsed() + elapsed)).attempt(fhres.getAttempt() + 1)).build();
            ipfsCache.put(fhres);
        }
        this.LOG.info("IPFS found: {}", (Object)fhres.toString(true));
        return fhres;
    }

    public List<FHandle> findContentAsync(Wallet.Address owner, final long timeout) {
        AbstractHandleManager.WorkerFactory<FHandle> factory = new AbstractHandleManager.WorkerFactory<FHandle>(){

            @Override
            public Class<FHandle> getType() {
                return FHandle.class;
            }

            @Override
            public Callable<FHandle> newWorker(FHandle fh) {
                return new AsyncGetCallable(fh, timeout);
            }
        };
        List<FHandle> fhandles = this.findContentAsync(owner, factory, timeout);
        return fhandles;
    }

    public byte[] createFileData(FHandle fhandle) {
        return this.dataHandler.createFileData(fhandle);
    }

    @Override
    public FHandle getHandleFromTx(Wallet.Address owner, UTXO utxo) {
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        AssertArgument.assertNotNull((Object)utxo, (String)"Null utxo");
        Wallet wallet = this.cntmgr.getBlockchain().getWallet();
        Tx tx = wallet.getTransaction(utxo.getTxId());
        if (!this.isOurs(tx)) {
            return null;
        }
        FHandle fhandle = null;
        List outs = tx.outputs();
        TxOutput out0 = (TxOutput)outs.get(outs.size() - 2);
        TxOutput out1 = (TxOutput)outs.get(outs.size() - 1);
        byte[] txdata = out1.getData();
        Multihash cid = this.dataHandler.extractFileData(txdata);
        Wallet.Address outAddr = wallet.findAddress(out0.getAddress());
        if (cid != null && outAddr != null) {
            this.LOG.debug("File Tx: {} => {}", (Object)tx.txId(), (Object)cid);
            if (!owner.equals(outAddr)) {
                return null;
            }
            fhandle = ((FHandle.FHBuilder)new FHandle.FHBuilder(owner, tx.txId(), cid).owner(owner)).build();
        }
        return fhandle;
    }

    public FHandle createFHandleTree(final FHandle fhandle) throws IOException {
        final Stack fhstack = new Stack();
        final Path rootPath = fhandle.getFilePath();
        final File rootFile = rootPath.toFile();
        AssertState.assertTrue((Boolean)rootFile.exists(), (String)("Cannot find IPFS content at: " + rootFile));
        final FHandle.FHReference fhref = new FHandle.FHReference();
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                URL furl = file.toUri().toURL();
                FHandle fhaux = new FHandle.FHBuilder(fhandle).url(furl).build();
                FHandle fhres = FHandleManager.this.createFromFileHeader(null, fhaux);
                Path path = fhres.getPath().getName(0);
                furl = rootFile.toURI().toURL();
                fhres = new FHandle.FHBuilder(fhres).path(path).url(furl).build();
                fhref.setFHandle(fhres);
                return FileVisitResult.TERMINATE;
            }
        });
        Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FHandle parent = !fhstack.isEmpty() ? (FHandle)fhstack.peek() : null;
                FHandle fhandle2 = this.createFileHandle(parent, dir);
                fhstack.push(fhandle2);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                fhstack.pop();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FHandle parent = !fhstack.isEmpty() ? (FHandle)fhstack.peek() : null;
                this.createFileHandle(parent, file);
                return FileVisitResult.CONTINUE;
            }

            FHandle createFileHandle(FHandle parent, Path fullPath) throws IOException {
                FHandle fhres;
                if (fullPath.toFile().isDirectory()) {
                    if (parent == null) {
                        fhres = fhref.getFHandle();
                    } else {
                        FHandle fhroot = fhref.getFHandle();
                        Path relPath = rootPath.relativize(fullPath);
                        relPath = fhroot.getPath().resolve(relPath);
                        URL furl = fullPath.toUri().toURL();
                        fhres = new FHandle.FHBuilder(fhandle).parent(parent).path(relPath).url(furl).build();
                    }
                } else {
                    URL furl = fullPath.toUri().toURL();
                    FHandle fhaux = new FHandle.FHBuilder(fhandle).url(furl).build();
                    fhres = FHandleManager.this.createFromFileHeader(parent, fhaux);
                }
                return fhres;
            }
        });
        FHandle fhres = fhref.getFHandle();
        AssertState.assertNotNull((Object)fhres, (String)("Cannot obtain fhandle for: " + rootFile));
        return fhres;
    }

    private FHandle createFromFileHeader(FHandle parent, FHandle fhandle) throws IOException {
        AssertArgument.assertNotNull((Object)fhandle, (String)"Null fhandle");
        Path fullPath = fhandle.getFilePath();
        AssertState.assertTrue((Boolean)fullPath.toFile().isFile(), (String)("Cannot find IPFS content at: " + fullPath));
        try (FileReader fr = new FileReader(fullPath.toFile());){
            FHandle fhres;
            FHeaderValues fhvals = this.cntmgr.getFHeaderValues();
            FHeader header = FHeader.fromReader(fhvals, fr);
            Wallet.Address owner = this.assertAddress(header.owner);
            String encToken = header.token;
            Path path = header.path;
            AssertState.assertEquals((Object)fhandle.getOwner(), (Object)owner, (String)("Unexpected owner: " + owner));
            boolean available = parent != null ? parent.isAvailable() : false;
            FHandle fHandle = fhres = ((FHandle.FHBuilder)new FHandle.FHBuilder(fhandle).secretToken(encToken).available(available).parent(parent).owner(owner)).path(path).build();
            return fHandle;
        }
    }

    private String logPrefix(String action, int attempt) {
        ContentManagerConfig config = this.cntmgr.getConfig();
        int ipfsAttempts = config.getIpfsAttempts();
        String trdName = Thread.currentThread().getName();
        return String.format("IPFS %s [%s] [%d/%d]", action, trdName, attempt, ipfsAttempts);
    }

    class AsyncGetCallable
    implements Callable<FHandle> {
        final long timeout;
        final FHandle fhandle;

        AsyncGetCallable(FHandle fhandle, long timeout) {
            AssertArgument.assertNotNull((Object)fhandle, (String)"Null fhandle");
            this.timeout = timeout;
            this.fhandle = fhandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FHandle call() throws Exception {
            IPFSCache ipfsCache = FHandleManager.this.cntmgr.getIPFSCache();
            FHandle fhaux = this.fhandle;
            Multihash cid = this.fhandle.getCid();
            try {
                fhaux = FHandleManager.this.getIpfsContent(fhaux, this.timeout);
            }
            catch (Exception ex) {
                fhaux = this.processException(cid, ex);
            }
            finally {
                ipfsCache.put(fhaux);
            }
            return fhaux;
        }

        private FHandle processException(Multihash cid, Exception ex) throws InterruptedException {
            IPFSCache ipfsCache = FHandleManager.this.cntmgr.getIPFSCache();
            ContentManagerConfig config = FHandleManager.this.cntmgr.getConfig();
            FHandle fhres = ipfsCache.get(cid, FHandle.class);
            int attempt = fhres.getAttempt();
            if (ex instanceof IPFSTimeoutException) {
                if (config.getIpfsAttempts() <= attempt) {
                    fhres = ((FHandle.FHBuilder)new FHandle.FHBuilder(fhres).expired(true)).build();
                }
                FHandleManager.this.LOG.info("{}: {}", (Object)FHandleManager.this.logPrefix("timeout", attempt), (Object)fhres);
            } else if (ex instanceof IPFSNotFoundException) {
                fhres = ((FHandle.FHBuilder)new FHandle.FHBuilder(fhres).expired(true)).build();
                FHandleManager.this.LOG.warn("{}: {}", (Object)FHandleManager.this.logPrefix("not found", attempt), (Object)fhres);
            } else {
                fhres = ((FHandle.FHBuilder)new FHandle.FHBuilder(fhres).expired(true)).build();
                FHandleManager.this.LOG.error(FHandleManager.this.logPrefix("error", attempt) + ": " + fhres, (Throwable)ex);
            }
            return fhres;
        }
    }
}

