/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.core;

import io.nessus.ipfs.FHandle;
import io.nessus.ipfs.core.FHeaderValues;
import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FHeader {
    public final FHeaderValues fhvals;
    public final Path path;
    public final String owner;
    public final String token;
    public final int length;

    private FHeader(FHeaderValues fhvals, Path path, String owner, String token, int length) {
        AssertArgument.assertNotNull((Object)fhvals, (String)"Null fhvals");
        AssertArgument.assertNotNull((Object)path, (String)"Null path");
        AssertArgument.assertNotNull((Object)owner, (String)"Null owner");
        AssertArgument.assertNotNull((Object)token, (String)"Null token");
        AssertArgument.assertTrue((Boolean)(length != 0 ? 1 : 0), (String)("Invalid length: " + length));
        this.fhvals = fhvals;
        this.path = path;
        this.owner = owner;
        this.token = token;
        this.length = length;
    }

    public static FHeader fromReader(FHeaderValues fhv, Reader rd) throws IOException {
        BufferedReader br = new BufferedReader(rd);
        String line = br.readLine();
        AssertState.assertTrue((Boolean)line.startsWith(fhv.VERSION_STRING), (String)("Invalid version: " + line));
        String version = line;
        Path path = null;
        String owner = null;
        String token = null;
        int length = line.length() + 1;
        while (line != null) {
            line = br.readLine();
            if (line == null) continue;
            length += line.length() + 1;
            if (line.startsWith("Path: ")) {
                path = Paths.get(line.substring(6), new String[0]);
                continue;
            }
            if (line.startsWith("Owner: ")) {
                owner = line.substring(7);
                continue;
            }
            if (line.startsWith("Token: ")) {
                token = line.substring(7);
                continue;
            }
            if (!line.startsWith(fhv.FILE_HEADER_END)) continue;
            line = null;
        }
        AssertState.assertEquals((Object)fhv.VERSION_STRING, (Object)version);
        FHeader fheader = new FHeader(fhv, path, owner, token, length);
        return fheader;
    }

    public static FHeader fromFHandle(FHeaderValues fhv, FHandle fhandle) {
        String owner = fhandle.getOwner().getAddress();
        String encToken = fhandle.getSecretToken();
        return new FHeader(fhv, fhandle.getPath(), owner, encToken, -1);
    }

    void write(Writer wr) {
        PrintWriter pw = new PrintWriter(wr);
        pw.println(this.fhvals.VERSION_STRING);
        pw.println(String.format("Path: %s", this.path));
        pw.println(String.format("Owner: %s", this.owner));
        pw.println(String.format("Token: %s", this.token));
        pw.println(this.fhvals.FILE_HEADER_END);
    }

    public String toString() {
        return String.format("[version=%s, owner=%s, path=%s, token=%s]", this.fhvals.VERSION, this.owner, this.path, this.token);
    }
}

