/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.core;

import io.ipfs.multihash.Multihash;
import io.nessus.ipfs.FHandle;
import io.nessus.ipfs.core.FHeaderValues;
import java.nio.ByteBuffer;
import java.util.Arrays;

class TxDataHandler {
    static final byte OP_ADDR_DATA = 16;
    static final byte OP_FILE_DATA = 32;
    static final byte OP_RETURN = 106;
    final String OP_PREFIX;

    TxDataHandler(FHeaderValues fhid) {
        this.OP_PREFIX = fhid.PREFIX;
    }

    byte[] createAddrData(Multihash cid) {
        byte[] bytes = cid.toBytes();
        return this.buffer((byte)16, bytes.length + 1).put((byte)bytes.length).put(bytes).array();
    }

    Multihash extractAddrData(byte[] txdata) {
        if (this.extractOpCode(txdata) != 16) {
            return null;
        }
        byte[] data = this.extractData(txdata);
        byte len = data[0];
        data = Arrays.copyOfRange(data, 1, 1 + len);
        return new Multihash(data);
    }

    byte[] createFileData(FHandle fhandle) {
        byte[] fid = fhandle.getCid().toBase58().getBytes();
        return this.buffer((byte)32, fid.length + 1).put((byte)fid.length).put(fid).array();
    }

    Multihash extractFileData(byte[] txdata) {
        if (this.extractOpCode(txdata) != 32) {
            return null;
        }
        byte[] data = this.extractData(txdata);
        byte len = data[0];
        data = Arrays.copyOfRange(data, 1, 1 + len);
        return Multihash.fromBase58((String)new String(data));
    }

    boolean isOurs(byte[] txdata) {
        byte[] prefix = this.OP_PREFIX.getBytes();
        if (txdata[0] != 106) {
            return false;
        }
        if (txdata[1] != txdata.length - 2) {
            return false;
        }
        byte[] aux = Arrays.copyOfRange(txdata, 2, 2 + prefix.length);
        return Arrays.equals(prefix, aux);
    }

    byte extractOpCode(byte[] txdata) {
        if (!this.isOurs(txdata)) {
            return -1;
        }
        byte[] prefix = this.OP_PREFIX.getBytes();
        byte opcode = txdata[prefix.length + 2];
        return opcode;
    }

    private byte[] extractData(byte[] txdata) {
        if (!this.isOurs(txdata)) {
            return null;
        }
        byte[] prefix = this.OP_PREFIX.getBytes();
        return Arrays.copyOfRange(txdata, 2 + prefix.length + 1, txdata.length);
    }

    private ByteBuffer buffer(byte op, int dlength) {
        byte[] prefix = this.OP_PREFIX.getBytes();
        ByteBuffer buffer = ByteBuffer.allocate(prefix.length + 1 + dlength);
        buffer.put(prefix);
        buffer.put(op);
        return buffer;
    }
}

