/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.jaxrs;

import io.nessus.ipfs.jaxrs.JAXRSEndpoint;
import io.nessus.ipfs.jaxrs.SFHandle;
import io.nessus.utils.AssertState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAXRSClient
implements JAXRSEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(JAXRSClient.class);
    final Client client = ClientBuilder.newClient();
    final URI urlRoot;

    public JAXRSClient(URI urlRoot) {
        this.urlRoot = urlRoot;
    }

    @Override
    public String registerAddress(String rawAddr) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/register")).queryParam("addr", new Object[]{rawAddr});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        String encKey = (String)res.readEntity(String.class);
        LOG.info("/register => {}", (Object)encKey);
        return encKey;
    }

    @Override
    public String unregisterAddress(String rawAddr) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/rmaddr")).queryParam("addr", new Object[]{rawAddr});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        String encKey = (String)res.readEntity(String.class);
        LOG.info("/rmaddr => {}", (Object)encKey);
        return encKey;
    }

    @Override
    public SFHandle add(String rawAddr, String relPath, InputStream input) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/add")).queryParam("addr", new Object[]{rawAddr}).queryParam("path", new Object[]{relPath});
        Response res = this.processResponse((Response)target.request().post(Entity.entity((Object)input, (String)"application/octet-stream"), Response.class));
        SFHandle shandle = (SFHandle)res.readEntity(SFHandle.class);
        LOG.info("/add => {}", (Object)shandle);
        return shandle;
    }

    @Override
    public SFHandle get(String rawAddr, String cid, String relPath, Long timeout) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/get")).queryParam("addr", new Object[]{rawAddr}).queryParam("path", new Object[]{relPath}).queryParam("timeout", new Object[]{timeout}).queryParam("cid", new Object[]{cid});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        SFHandle shandle = (SFHandle)res.readEntity(SFHandle.class);
        LOG.info("/get => {}", (Object)shandle);
        return shandle;
    }

    @Override
    public SFHandle send(String rawAddr, String cid, String rawTarget, Long timeout) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/send")).queryParam("addr", new Object[]{rawAddr}).queryParam("target", new Object[]{rawTarget}).queryParam("cid", new Object[]{cid}).queryParam("timeout", new Object[]{timeout});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        SFHandle shandle = (SFHandle)res.readEntity(SFHandle.class);
        LOG.info("/send => {}", (Object)shandle);
        return shandle;
    }

    @Override
    public String findAddressRegistation(String rawAddr) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/findkey")).queryParam("addr", new Object[]{rawAddr});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        if (Response.Status.NO_CONTENT.getStatusCode() == res.getStatus()) {
            return null;
        }
        String encKey = (String)res.readEntity(String.class);
        LOG.info("/findkey => {}", (Object)encKey);
        return encKey;
    }

    @Override
    public List<SFHandle> findIPFSContent(String rawAddr, Long timeout) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/findipfs")).queryParam("addr", new Object[]{rawAddr}).queryParam("timeout", new Object[]{timeout});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        List<Object> result = Arrays.asList((Object[])res.readEntity(SFHandle[].class));
        LOG.info("/findipfs => {}", result);
        return result;
    }

    @Override
    public List<String> removeIPFSContent(String rawAddr, List<String> cids) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/rmipfs")).queryParam("addr", new Object[]{rawAddr}).queryParam("cids", cids.toArray());
        Response res = this.processResponse((Response)target.request().get(Response.class));
        List<Object> result = Arrays.asList((Object[])res.readEntity(String[].class));
        LOG.info("/rmipfs => {}", result);
        return result;
    }

    @Override
    public List<SFHandle> findLocalContent(String rawAddr) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/findlocal")).queryParam("addr", new Object[]{rawAddr});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        List<Object> result = Arrays.asList((Object[])res.readEntity(SFHandle[].class));
        LOG.info("/findlocal => {}", result);
        return result;
    }

    @Override
    public InputStream getLocalContent(String rawAddr, String path) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/getlocal")).queryParam("addr", new Object[]{rawAddr}).queryParam("path", new Object[]{path});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        InputStream content = (InputStream)res.readEntity(InputStream.class);
        LOG.info("/getlocal => {}", (Object)content);
        return content;
    }

    @Override
    public boolean removeLocalContent(String rawAddr, String path) throws IOException {
        WebTarget target = this.client.target(this.generateURL("/rmlocal")).queryParam("addr", new Object[]{rawAddr}).queryParam("path", new Object[]{path});
        Response res = this.processResponse((Response)target.request().get(Response.class));
        Boolean deleted = (Boolean)res.readEntity(Boolean.class);
        LOG.info("/rmlocal => {}", (Object)deleted);
        return deleted;
    }

    private Response processResponse(Response res) throws IOException {
        Response.Status status = Response.Status.fromStatusCode((int)res.getStatus());
        if (status == Response.Status.INTERNAL_SERVER_ERROR) {
            Exception ex;
            String message;
            String errorType;
            String stackTrace = (String)res.readEntity(String.class);
            LOG.error(status.getReasonPhrase());
            LOG.error(stackTrace);
            String line = new BufferedReader(new StringReader(stackTrace)).readLine();
            int colIdx = line.indexOf(58);
            if (colIdx > 0) {
                errorType = line.substring(0, colIdx);
                message = line.substring(colIdx + 2);
            } else {
                errorType = line;
                message = "";
            }
            try {
                Class<?> clazz = JAXRSClient.class.getClassLoader().loadClass(errorType);
                ex = (Exception)clazz.getConstructor(String.class).newInstance(message);
            }
            catch (Exception refex) {
                throw new InternalServerErrorException(line);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new IllegalStateException(ex);
        }
        if (status != Response.Status.NO_CONTENT) {
            if (status != Response.Status.OK) {
                LOG.error("{} - {}", (Object)status.getStatusCode(), (Object)status.getReasonPhrase());
            }
            AssertState.assertEquals((Object)Response.Status.OK, (Object)status, (String)status.getReasonPhrase());
        }
        return res;
    }

    private String generateURL(String path) {
        return this.urlRoot + path;
    }
}

