/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.jaxrs;

import io.nessus.Wallet;
import io.nessus.core.ipfs.ContentManager;
import io.nessus.core.ipfs.FHandle;
import io.nessus.ipfs.jaxrs.JAXRSApplication;
import io.nessus.ipfs.jaxrs.JAXRSEndpoint;
import io.nessus.ipfs.jaxrs.SFHandle;
import io.nessus.utils.AssertState;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAXRSResource
implements JAXRSEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(JAXRSResource.class);
    final ContentManager cntmgr;

    public JAXRSResource() throws IOException {
        JAXRSApplication app = JAXRSApplication.getInstance();
        this.cntmgr = app.getContentManager();
    }

    @Override
    public SFHandle add(String rawAddr, String path, InputStream input) throws IOException, GeneralSecurityException {
        Wallet.Address owner = this.assertWalletAddress(rawAddr);
        FHandle fhandle = this.cntmgr.add(owner, input, Paths.get(path, new String[0]));
        AssertState.assertTrue((Boolean)new File(fhandle.getURL().getPath()).exists());
        AssertState.assertNotNull((Object)fhandle.getCid());
        SFHandle shandle = new SFHandle(fhandle);
        LOG.info("/add => {}", (Object)shandle);
        return shandle;
    }

    @Override
    public String findAddressRegistation(String rawAddr) {
        Wallet.Address addr = this.assertWalletAddress(rawAddr);
        PublicKey pubKey = this.cntmgr.findAddressRegistation(addr);
        String encKey = pubKey != null ? Base64.getEncoder().encodeToString(pubKey.getEncoded()) : null;
        LOG.info("/findkey => {}", (Object)encKey);
        return encKey;
    }

    @Override
    public List<SFHandle> findIPFSContent(String rawAddr, Long timeout) throws IOException {
        ArrayList<SFHandle> result = new ArrayList<SFHandle>();
        Wallet.Address owner = this.assertWalletAddress(rawAddr);
        for (FHandle fhandle : this.cntmgr.findIPFSContent(owner, timeout)) {
            result.add(new SFHandle(fhandle));
        }
        LOG.info("/findipfs => {}", result);
        return result;
    }

    @Override
    public List<SFHandle> findLocalContent(String rawAddr) throws IOException {
        ArrayList<SFHandle> result = new ArrayList<SFHandle>();
        Wallet.Address owner = this.assertWalletAddress(rawAddr);
        for (FHandle fhandle : this.cntmgr.findLocalContent(owner)) {
            result.add(new SFHandle(fhandle));
        }
        LOG.info("/findlocal => {}", result);
        return result;
    }

    @Override
    public SFHandle get(String rawAddr, String cid, String path, Long timeout) throws IOException, GeneralSecurityException {
        Wallet.Address owner = this.assertWalletAddress(rawAddr);
        FHandle fhandle = this.cntmgr.get(owner, cid, Paths.get(path, new String[0]), timeout);
        AssertState.assertTrue((Boolean)new File(fhandle.getURL().getPath()).exists());
        AssertState.assertNull((Object)fhandle.getCid());
        SFHandle shandle = new SFHandle(fhandle);
        LOG.info("/get => {}", (Object)shandle);
        return shandle;
    }

    @Override
    public InputStream getLocalContent(String rawAddr, String path) throws IOException {
        Wallet.Address owner = this.assertWalletAddress(rawAddr);
        InputStream content = this.cntmgr.getLocalContent(owner, Paths.get(path, new String[0]));
        LOG.info("/getlocal => {}", (Object)content);
        return content;
    }

    @Override
    public String registerAddress(String rawAddr) throws GeneralSecurityException {
        Wallet.Address addr = this.assertWalletAddress(rawAddr);
        PublicKey pubKey = this.cntmgr.registerAddress(addr);
        LOG.info("/register => {}", (Object)pubKey);
        String encKey = Base64.getEncoder().encodeToString(pubKey.getEncoded());
        return encKey;
    }

    @Override
    public boolean removeLocalContent(String rawAddr, String path) throws IOException {
        Wallet.Address owner = this.assertWalletAddress(rawAddr);
        boolean deleted = this.cntmgr.removeLocalContent(owner, Paths.get(path, new String[0]));
        LOG.info("/rmlocal => {}", (Object)deleted);
        return deleted;
    }

    @Override
    public SFHandle send(String rawAddr, String cid, @QueryParam(value="target") String rawTarget, Long timeout) throws IOException, GeneralSecurityException {
        Wallet.Address owner = this.assertWalletAddress(rawAddr);
        Wallet.Address target = this.assertWalletAddress(rawTarget);
        FHandle fhandle = this.cntmgr.send(owner, cid, target, timeout);
        AssertState.assertNotNull((Object)fhandle.getCid());
        SFHandle shandle = new SFHandle(fhandle);
        LOG.info("/send => {}", (Object)shandle);
        return shandle;
    }

    @Override
    public String unregisterAddress(String rawAddr) {
        Wallet.Address addr = this.assertWalletAddress(rawAddr);
        PublicKey pubKey = this.cntmgr.unregisterAddress(addr);
        LOG.info("/rmaddr => {}", (Object)pubKey);
        String encKey = Base64.getEncoder().encodeToString(pubKey.getEncoded());
        return encKey;
    }

    @Override
    public List<String> removeIPFSContent(String rawAddr, List<String> cids) throws IOException {
        Wallet.Address owner = this.assertWalletAddress(rawAddr);
        List result = this.cntmgr.removeIPFSContent(owner, cids);
        LOG.info("/rmipfs => {}", (Object)result);
        return result;
    }

    private Wallet.Address assertWalletAddress(String rawAddr) {
        Wallet.Address addr = this.cntmgr.getBlockchain().getWallet().findAddress(rawAddr);
        AssertState.assertNotNull((Object)addr, (String)("Unknown address: " + rawAddr));
        return addr;
    }
}

