/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.jaxrs;

import io.nessus.core.ipfs.FHandle;
import java.nio.file.Path;

public class SFHandle {
    private String cid;
    private String owner;
    private String path;
    private String txId;
    private boolean encrypted;
    private boolean available;
    private boolean expired;
    private int attempts;
    private Long elapsed;

    public SFHandle() {
    }

    public SFHandle(String cid, String owner, String path, boolean available, boolean encrypted) {
        this.cid = cid;
        this.owner = owner;
        this.path = path;
        this.available = available;
        this.encrypted = encrypted;
    }

    SFHandle(FHandle fhandle) {
        Path path = fhandle.getPath();
        this.cid = fhandle.getCid();
        this.owner = fhandle.getOwner().getAddress();
        this.path = path != null ? path.toString() : null;
        this.txId = fhandle.getTxId();
        this.encrypted = fhandle.isEncrypted();
        this.available = fhandle.isAvailable();
        this.expired = fhandle.isExpired();
        this.attempts = fhandle.getAttempt();
        this.elapsed = fhandle.getElapsed();
    }

    public String getCid() {
        return this.cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTxId() {
        return this.txId;
    }

    public void setTxId(String txId) {
        this.txId = txId;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    public Long getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(Long elapsed) {
        this.elapsed = elapsed;
    }

    public String toString() {
        return String.format("[cid=%s, owner=%s, path=%s, avl=%b, exp=%b, try=%d, time=%s]", this.cid, this.owner, this.path, this.available, this.expired, this.attempts, this.elapsed);
    }
}

