/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.jaxrs;

import io.ipfs.multihash.Multihash;
import io.nessus.Network;
import io.nessus.Wallet;
import io.nessus.cipher.utils.RSAUtils;
import io.nessus.ipfs.AHandle;
import io.nessus.ipfs.ContentManager;
import io.nessus.ipfs.FHandle;
import io.nessus.ipfs.jaxrs.JAXRSApplication;
import io.nessus.ipfs.jaxrs.JAXRSClient;
import io.nessus.ipfs.jaxrs.JAXRSEndpoint;
import io.nessus.ipfs.jaxrs.SAHandle;
import io.nessus.ipfs.jaxrs.SFHandle;
import io.nessus.utils.AssertArgument;
import io.nessus.utils.AssertState;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAXRSResource
implements JAXRSEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(JAXRSResource.class);
    private final ContentManager cntmgr;

    public JAXRSResource() throws IOException {
        this.cntmgr = JAXRSApplication.INSTANCE.cntManager;
    }

    @Override
    public SAHandle registerAddress(String addr) throws GeneralSecurityException, IOException {
        this.assertBlockchainNetworkAvailable();
        Wallet.Address owner = this.assertWalletAddress(addr);
        AHandle ahandle = this.cntmgr.registerAddress(owner);
        PublicKey pubKey = ahandle.getPubKey();
        SAHandle shandle = this.createAddrHandle(owner, pubKey);
        LOG.info("/regaddr {} => {}", (Object)addr, (Object)shandle);
        return shandle;
    }

    @Override
    public List<SAHandle> findAddressInfo(String label, String addr) {
        this.assertBlockchainNetworkAvailable();
        Wallet.Address owner = addr != null ? this.assertWalletAddress(addr) : null;
        Wallet wallet = this.cntmgr.getBlockchain().getWallet();
        List<SAHandle> shandles = wallet.getAddresses().stream().filter(a -> !a.getLabels().contains("(change)")).filter(a -> owner == null || a.equals(owner)).filter(a -> label == null || a.getLabels().contains(label)).map(a -> {
            AHandle ahandle = this.cntmgr.findAddressRegistation(a, null);
            PublicKey pubKey = ahandle != null ? ahandle.getPubKey() : null;
            SAHandle shandle = this.createAddrHandle((Wallet.Address)a, pubKey);
            return shandle;
        }).collect(Collectors.toList());
        if (shandles.size() < 2) {
            LOG.info("/addrinfo {} {} => {}", new Object[]{label, addr, shandles});
        } else {
            LOG.info("/addrinfo {} {} => {} addrs", new Object[]{label, addr, shandles.size()});
        }
        return shandles;
    }

    @Override
    public SAHandle unregisterAddress(String addr) {
        this.assertBlockchainNetworkAvailable();
        Wallet.Address owner = this.assertWalletAddress(addr);
        AHandle ahandle = this.cntmgr.unregisterAddress(owner);
        PublicKey pubKey = ahandle != null ? ahandle.getPubKey() : null;
        SAHandle shandle = this.createAddrHandle(owner, pubKey);
        LOG.info("/rmaddr {} => {}", (Object)addr, (Object)shandle);
        return shandle;
    }

    @Override
    public SFHandle addIpfsContent(String addr, String path, URL srcUrl) throws IOException, GeneralSecurityException {
        AssertArgument.assertTrue((Boolean)(path != null || srcUrl != null ? 1 : 0), (String)"Path or URL must be given");
        this.assertBlockchainNetworkAvailable();
        Wallet.Address owner = this.assertWalletAddress(addr);
        FHandle fhandle = srcUrl != null ? this.cntmgr.addIpfsContent(owner, Paths.get(path, new String[0]), srcUrl) : this.cntmgr.addIpfsContent(owner, Paths.get(path, new String[0]));
        SFHandle shandle = new SFHandle(fhandle);
        LOG.info("/addipfs {}", (Object)shandle);
        return shandle;
    }

    @Override
    public SFHandle addIpfsContent(String addr, String path, InputStream input) throws IOException, GeneralSecurityException {
        this.assertBlockchainNetworkAvailable();
        Wallet.Address owner = this.assertWalletAddress(addr);
        FHandle fhandle = this.cntmgr.addIpfsContent(owner, Paths.get(path, new String[0]), input);
        SFHandle shandle = new SFHandle(fhandle);
        LOG.info("/addipfs {}", (Object)shandle);
        return shandle;
    }

    @Override
    public SFHandle getIpfsContent(String addr, String cid, String path, Long timeout) throws IOException, GeneralSecurityException {
        this.assertBlockchainNetworkAvailable();
        Wallet.Address owner = this.assertWalletAddress(addr);
        FHandle fhandle = this.cntmgr.getIpfsContent(owner, Multihash.fromBase58((String)cid), Paths.get(path, new String[0]), timeout);
        SFHandle shandle = new SFHandle(fhandle);
        LOG.info("/getipfs {} => {}", (Object)cid, (Object)shandle);
        return shandle;
    }

    @Override
    public SFHandle sendIpfsContent(String addr, String cid, @QueryParam(value="target") String rawTarget, Long timeout) throws IOException, GeneralSecurityException {
        this.assertBlockchainNetworkAvailable();
        Wallet.Address owner = this.assertWalletAddress(addr);
        Wallet.Address target = this.assertWalletAddress(rawTarget);
        FHandle fhandle = this.cntmgr.sendIpfsContent(owner, Multihash.fromBase58((String)cid), target, timeout);
        SFHandle shandle = new SFHandle(fhandle);
        LOG.info("/sendipfs {} => {}", (Object)cid, (Object)shandle);
        return shandle;
    }

    @Override
    public List<SFHandle> findIpfsContent(String addr, Long timeout) throws IOException {
        this.assertBlockchainNetworkAvailable();
        ArrayList<SFHandle> shandles = new ArrayList<SFHandle>();
        Wallet.Address owner = this.assertWalletAddress(addr);
        for (FHandle fh : this.cntmgr.findIpfsContent(owner, timeout)) {
            shandles.add(new SFHandle(fh));
        }
        if (shandles.size() < 2) {
            LOG.info("/findipfs {} => {}", (Object)addr, shandles);
        } else {
            LOG.info("/findipfs {} => {} files", (Object)addr, (Object)shandles.size());
        }
        return shandles;
    }

    @Override
    public List<String> unregisterIpfsContent(String addr, List<String> rawids) throws IOException {
        this.assertBlockchainNetworkAvailable();
        Wallet.Address owner = this.assertWalletAddress(addr);
        List cids = rawids.stream().map(id -> Multihash.fromBase58((String)id)).collect(Collectors.toList());
        List result = this.cntmgr.unregisterIpfsContent(owner, cids);
        LOG.info("/rmipfs {} {} => {}", new Object[]{addr, cids, result});
        return result.stream().map(cid -> cid.toBase58()).collect(Collectors.toList());
    }

    @Override
    public List<SFHandle> findLocalContent(String addr, String path) throws IOException {
        this.assertBlockchainNetworkAvailable();
        ArrayList<SFHandle> shandles = new ArrayList<SFHandle>();
        Wallet.Address owner = this.assertWalletAddress(addr);
        if (path == null) {
            for (FHandle fhres : this.cntmgr.findLocalContent(owner)) {
                shandles.add(new SFHandle(fhres));
            }
        } else {
            FHandle fhres = this.cntmgr.findLocalContent(owner, Paths.get(path, new String[0]));
            if (fhres != null) {
                shandles.add(new SFHandle(fhres));
            }
        }
        if (shandles.size() < 2) {
            LOG.info("/findlocal {} {} => {}", new Object[]{addr, path, shandles});
        } else {
            LOG.info("/findlocal {} {} => {} files", new Object[]{addr, path, shandles.size()});
        }
        return shandles;
    }

    @Override
    public InputStream getLocalContent(String addr, String path) throws IOException {
        this.assertBlockchainNetworkAvailable();
        Wallet.Address owner = this.assertWalletAddress(addr);
        InputStream content = this.cntmgr.getLocalContent(owner, Paths.get(path, new String[0]));
        LOG.info("/getlocal {} {}", (Object)addr, (Object)path);
        return content;
    }

    @Override
    public boolean removeLocalContent(String addr, String path) throws IOException {
        this.assertBlockchainNetworkAvailable();
        Wallet.Address owner = this.assertWalletAddress(addr);
        boolean removed = this.cntmgr.removeLocalContent(owner, Paths.get(path, new String[0]));
        LOG.info("/rmlocal {} {} => {}", new Object[]{addr, path, removed});
        return removed;
    }

    private void assertBlockchainNetworkAvailable() {
        Network network = this.cntmgr.getBlockchain().getNetwork();
        JAXRSClient.assertBlockchainNetworkAvailable(network);
    }

    private Wallet.Address assertWalletAddress(String rawaddr) {
        Wallet.Address addr = this.cntmgr.getBlockchain().getWallet().findAddress(rawaddr);
        AssertState.assertNotNull((Object)addr, (String)("Unknown address: " + addr));
        return addr;
    }

    private SAHandle createAddrHandle(Wallet.Address owner, PublicKey pubKey) {
        Wallet wallet = this.cntmgr.getBlockchain().getWallet();
        String encKey = pubKey != null ? RSAUtils.encodeKey((Key)pubKey) : null;
        return new SAHandle(owner, encKey, wallet.getBalance(owner));
    }
}

