/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.jaxrs;

import io.nessus.Blockchain;
import io.nessus.ipfs.ContentManager;
import io.nessus.ipfs.ContentManagerConfig;
import io.nessus.ipfs.client.IPFSClient;
import io.nessus.ipfs.core.DefaultContentManager;
import io.nessus.ipfs.jaxrs.JAXRSClient;
import io.nessus.ipfs.jaxrs.JAXRSConfig;
import io.nessus.ipfs.jaxrs.JAXRSResource;
import io.nessus.ipfs.jaxrs.JAXRSSanityCheck;
import io.nessus.utils.AssertArgument;
import io.undertow.Undertow;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.server.undertow.UndertowJaxrsServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAXRSApplication
extends Application {
    private static final Logger LOG = LoggerFactory.getLogger(JAXRSApplication.class);
    private static final String implVersion;
    private static final String implBuild;
    private static JAXRSConfig config;
    private static JAXRSServer jaxrsServer;
    static JAXRSApplication INSTANCE;
    final ContentManager cntManager;

    public JAXRSApplication() throws Exception {
        this(config);
    }

    public JAXRSApplication(JAXRSConfig config) throws Exception {
        AssertArgument.assertNotNull((Object)((Object)config), (String)"Null config");
        String buildNumber = JAXRSApplication.getImplBuild() != null ? "Build: " + JAXRSApplication.getImplBuild() : "";
        LOG.info("Nessus Version: {} {}", (Object)JAXRSApplication.getImplVersion(), (Object)buildNumber);
        Blockchain blockchain = config.getBlockchain();
        JAXRSClient.logBlogchainNetworkAvailable(blockchain.getNetwork());
        IPFSClient ipfsClient = config.getIPFSClient();
        LOG.info("IPFS PeerId: {}", (Object)ipfsClient.getPeerId());
        LOG.info("IPFS Address: {}", (Object)ipfsClient.getAPIAddress());
        LOG.info("IPFS Version: {}", (Object)ipfsClient.version());
        this.cntManager = new DefaultContentManager(ipfsClient, blockchain, (ContentManagerConfig)config);
        LOG.info("DefaultContentManager{}", (Object)config);
        INSTANCE = this;
    }

    static String getImplVersion() {
        return implVersion;
    }

    static String getImplBuild() {
        boolean snapshot = implVersion != null && implVersion.endsWith("SNAPSHOT");
        return snapshot ? implBuild : null;
    }

    public static JAXRSServer serverStart(JAXRSConfig config) throws Exception {
        JAXRSSanityCheck.verifyPlatform();
        JAXRSApplication.config = config;
        Undertow.Builder builder = Undertow.builder().addHttpListener(config.jaxrsPort, config.jaxrsHost);
        UndertowJaxrsServer undertowServer = new UndertowJaxrsServer().start(builder);
        String ctxpath = config.jaxrsPath;
        undertowServer.deploy(JAXRSApplication.class, ctxpath);
        jaxrsServer = new JAXRSServer(undertowServer, config);
        LOG.info("Nessus JAXRS: {}", (Object)jaxrsServer.getRootURL());
        return jaxrsServer;
    }

    public static void serverStop() {
        if (jaxrsServer != null) {
            jaxrsServer.stop();
            jaxrsServer = null;
        }
    }

    public Set<Object> getSingletons() {
        HashSet<Object> singletons = new HashSet<Object>();
        Collections.addAll(singletons, this.cntManager);
        return singletons;
    }

    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet();
        classes.add(JAXRSResource.class);
        classes.add(RuntimeExceptionMapper.class);
        classes.add(GeneralSecurityExceptionMapper.class);
        classes.add(IOExceptionMapper.class);
        return classes;
    }

    static {
        try (InputStream ins = JAXRSApplication.class.getResourceAsStream("/META-INF/MANIFEST.MF");){
            Manifest manifest = new Manifest(ins);
            Attributes attribs = manifest.getMainAttributes();
            implVersion = attribs.getValue("Implementation-Version");
            implBuild = attribs.getValue("Implementation-Build");
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static class AbstractExceptionMapper<T extends Exception>
    implements ExceptionMapper<T> {
        public Response toResponse(T ex) {
            StringWriter strwr = new StringWriter();
            ((Throwable)ex).printStackTrace(new PrintWriter(strwr));
            LOG.error("ERROR executing request", ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)strwr.toString()).build();
        }
    }

    @Provider
    public static class RuntimeExceptionMapper
    extends AbstractExceptionMapper<RuntimeException> {
    }

    @Provider
    public static class GeneralSecurityExceptionMapper
    extends AbstractExceptionMapper<GeneralSecurityException> {
    }

    @Provider
    public static class IOExceptionMapper
    extends AbstractExceptionMapper<IOException> {
    }

    public static class JAXRSServer {
        final JAXRSConfig options;
        final UndertowJaxrsServer server;

        JAXRSServer(UndertowJaxrsServer server, JAXRSConfig options) {
            this.options = options;
            this.server = server;
        }

        public URL getRootURL() {
            try {
                return new URL(String.format("http://%s:%d/nessus", this.options.jaxrsHost, this.options.jaxrsPort));
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public void stop() {
            this.server.stop();
        }
    }
}

