/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.jaxrs;

import io.nessus.ipfs.ContentManagerConfig;
import io.nessus.utils.SystemUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import org.kohsuke.args4j.Option;

public final class JAXRSConfig
extends ContentManagerConfig {
    public static final String ENV_NESSUS_JAXRS_ADDR = "NESSUS_JAXRS_ADDR";
    public static final String ENV_NESSUS_JAXRS_PORT = "NESSUS_JAXRS_PORT";
    public static final String ENV_NESSUS_JAXRS_CONTEXT_PATH = "NESSUS_JAXRS_CONTEXT_PATH";
    public static final String DEFAULT_JAXRS_CONTEXT_PATH = "nessus";
    public static final String DEFAULT_JAXRS_HOST = "0.0.0.0";
    public static final int DEFAULT_JAXRS_PORT = 8081;
    @Option(name="--jaxrs-host", usage="The Nessus JAXRS host")
    String jaxrsHost = "0.0.0.0";
    @Option(name="--jaxrs-port", usage="The Nessus JAXRS port")
    int jaxrsPort = 8081;
    @Option(name="--jaxrs-path", usage="The JAXRS context path")
    String jaxrsPath = "nessus";

    public JAXRSConfig() {
    }

    private JAXRSConfig(String ipfsAddr, String bcImpl, String bcUrl, String bcHost, int bcPort, String bcUser, String bcPass, long ipfsTimeout, int ipfsAttempts, int ipfsThreads, Path dataDir, boolean overwrite, String jaxrsHost, int jaxrsPort, String jaxrsPath) {
        super(bcImpl, bcUrl, bcHost, bcPort, bcUser, bcPass, ipfsAddr, ipfsTimeout, ipfsAttempts, ipfsThreads, dataDir, overwrite);
        this.jaxrsHost = jaxrsHost;
        this.jaxrsPort = jaxrsPort;
        this.jaxrsPath = jaxrsPath;
    }

    public URL getJaxrsUrl() throws MalformedURLException {
        if (DEFAULT_JAXRS_HOST.equals(this.jaxrsHost)) {
            this.jaxrsHost = SystemUtils.getenv((String)ENV_NESSUS_JAXRS_ADDR, (String)this.jaxrsHost);
        }
        if (8081 == this.jaxrsPort) {
            this.jaxrsPort = Integer.parseInt(SystemUtils.getenv((String)ENV_NESSUS_JAXRS_PORT, (String)("" + this.jaxrsPort)));
        }
        if (DEFAULT_JAXRS_CONTEXT_PATH == this.jaxrsPath) {
            this.jaxrsPath = SystemUtils.getenv((String)ENV_NESSUS_JAXRS_CONTEXT_PATH, (String)("" + this.jaxrsPath));
        }
        return new URL(String.format("http://%s:%s/%s", this.jaxrsHost, this.jaxrsPort, this.jaxrsPath));
    }

    public String toString() {
        return String.format("[dataDir=%s, timeout=%s, attempts=%s, threads=%s, overwrite=%b]", this.dataDir, this.ipfsTimeout, this.ipfsAttempts, this.ipfsThreads, this.overwrite);
    }

    public static class JAXRSConfigBuilder
    extends ContentManagerConfig.AbstractContentManagerConfigBuilder<JAXRSConfigBuilder, JAXRSConfig> {
        String jaxrsPath = "nessus";
        String jaxrsHost = "0.0.0.0";
        int jaxrsPort = 8081;

        public JAXRSConfigBuilder jaxrsHost(String jaxrsHost) {
            this.jaxrsHost = jaxrsHost;
            return this;
        }

        public JAXRSConfigBuilder jaxrsPort(int jaxrsPort) {
            this.jaxrsPort = jaxrsPort;
            return this;
        }

        public JAXRSConfigBuilder jaxrsPath(String jaxrsPath) {
            this.jaxrsPath = jaxrsPath;
            return this;
        }

        public JAXRSConfig build() {
            return new JAXRSConfig(this.ipfsAddr, this.bcImpl, this.bcUrl, this.bcHost, this.bcPort, this.bcUser, this.bcPass, this.ipfsTimeout, this.ipfsAttempts, this.ipfsThreads, this.dataDir, this.overwrite, this.jaxrsHost, this.jaxrsPort, this.jaxrsPath);
        }
    }
}

