/*
 * Decompiled with CFR 0.152.
 */
package io.nessus.ipfs.jaxrs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.nessus.Wallet;
import io.nessus.utils.AssertArgument;
import java.math.BigDecimal;

public class SAHandle {
    private String label;
    private String addr;
    private BigDecimal balance;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private String encKey;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private boolean wonly;

    public SAHandle() {
    }

    public SAHandle(Wallet.Address addr, String encKey, BigDecimal balance) {
        AssertArgument.assertNotNull((Object)addr, (String)"Null addr");
        AssertArgument.assertNotNull((Object)balance, (String)"Null balance");
        AssertArgument.assertTrue((Boolean)(addr.getLabels().size() < 2 ? 1 : 0), (String)("Multiple labels: " + addr));
        this.label = addr.getLabels().stream().findFirst().orElse(null);
        this.addr = addr.getAddress();
        this.encKey = encKey;
        this.balance = balance;
        this.wonly = addr.isWatchOnly();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getAddress() {
        return this.addr;
    }

    public void setAddress(String addr) {
        this.addr = addr;
    }

    public String getEncKey() {
        return this.encKey;
    }

    public void setEncKey(String encKey) {
        this.encKey = encKey;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public boolean isWatchOnly() {
        return this.wonly;
    }

    public void setWatchOnly(boolean wonly) {
        this.wonly = wonly;
    }

    @JsonIgnore
    public boolean isRegistered() {
        return this.encKey != null;
    }

    public String toString() {
        String key = this.encKey != null ? this.encKey.substring(0, 8) : null;
        return String.format("[addr=%s, label=%s, wo=%b, key=%s, bal=%.6f]", this.addr, this.label, this.wonly, key, this.balance);
    }
}

