/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.HttpRequestParser;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ParseState;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import java.nio.ByteBuffer;
import java.util.Deque;
import org.junit.Assert;
import org.junit.Test;

public class ParserResumeTestCase {
    public static final String DATA = "POST http://www.somehost.net/apath?key1=value1&key2=value2 HTTP/1.1\r\nHost:   www.somehost.net\r\nOtherHeader: some\r\n    value\r\nHostee:another\r\nAccept-garbage:   a\r\n\r\ntttt";

    @Test
    public void testMethodSplit() {
        byte[] in = DATA.getBytes();
        for (int i = 0; i < in.length - 4; ++i) {
            try {
                this.testResume(i, in);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("Test failed at split " + i, e);
            }
        }
    }

    @Test
    public void testOneCharacterAtATime() {
        byte[] in = DATA.getBytes();
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null);
        ByteBuffer buffer = ByteBuffer.wrap(in);
        buffer.limit(1);
        while (context.state != 6) {
            HttpRequestParser.INSTANCE.handle(buffer, context, result);
            buffer.limit(buffer.limit() + 1);
        }
        this.runAssertions(result, context);
    }

    private void testResume(int split, byte[] in) {
        ParseState context = new ParseState();
        HttpServerExchange result = new HttpServerExchange(null);
        ByteBuffer buffer = ByteBuffer.wrap(in);
        buffer.limit(split);
        HttpRequestParser.INSTANCE.handle(buffer, context, result);
        buffer.limit(buffer.capacity());
        HttpRequestParser.INSTANCE.handle(buffer, context, result);
        this.runAssertions(result, context);
        Assert.assertEquals((long)4L, (long)buffer.remaining());
    }

    private void runAssertions(HttpServerExchange result, ParseState context) {
        Assert.assertSame((Object)Methods.POST, (Object)result.getRequestMethod());
        Assert.assertEquals((Object)"/apath", (Object)result.getRelativePath());
        Assert.assertEquals((Object)"http://www.somehost.net/apath", (Object)result.getRequestURI());
        Assert.assertSame((Object)Protocols.HTTP_1_1, (Object)result.getProtocol());
        Assert.assertEquals((Object)"www.somehost.net", (Object)result.getRequestHeaders().getFirst(new HttpString("Host")));
        Assert.assertEquals((Object)"some value", (Object)result.getRequestHeaders().getFirst(new HttpString("OtherHeader")));
        Assert.assertEquals((Object)"another", (Object)result.getRequestHeaders().getFirst(new HttpString("Hostee")));
        Assert.assertEquals((Object)"a", (Object)result.getRequestHeaders().getFirst(new HttpString("Accept-garbage")));
        Assert.assertEquals((long)4L, (long)result.getRequestHeaders().getHeaderNames().size());
        Assert.assertEquals((long)6L, (long)context.state);
        Assert.assertEquals((Object)"key1=value1&key2=value2", (Object)result.getQueryString());
        Assert.assertEquals((Object)"value1", ((Deque)result.getQueryParameters().get("key1")).getFirst());
        Assert.assertEquals((Object)"value2", ((Deque)result.getQueryParameters().get("key2")).getFirst());
    }
}

