/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.test.handlers.error;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.error.FileErrorPageHandler;
import io.undertow.test.utils.DefaultServer;
import io.undertow.test.utils.HttpClientUtils;
import io.undertow.util.TestHttpClient;
import java.io.File;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class FileErrorPageHandlerTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileBasedErrorPageIsGenerated() throws IOException {
        TestHttpClient client = new TestHttpClient();
        try {
            FileErrorPageHandler handler = new FileErrorPageHandler(new File(this.getClass().getResource("errorpage.html").getFile()), new Integer[]{404});
            DefaultServer.setRootHandler((HttpHandler)handler);
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)404L, (long)result.getStatusLine().getStatusCode());
            String response = HttpClientUtils.readResponse(result);
            Assert.assertTrue((String)response, (boolean)response.contains("Custom Error Page"));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

