/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.io;

import io.undertow.UndertowMessages;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.charset.Charset;
import org.xnio.Buffers;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.channels.StreamSinkChannel;

public class AsyncSenderImpl
implements Sender {
    private static final Charset utf8 = Charset.forName("UTF-8");
    private final StreamSinkChannel streamSinkChannel;
    private final HttpServerExchange exchange;
    private ByteBuffer[] buffer;
    private IoCallback callback;
    private boolean inCallback;
    private final ChannelListener<Channel> writeListener = new ChannelListener<Channel>(){

        public void handleEvent(Channel channel) {
            try {
                long res;
                long toWrite = Buffers.remaining((Buffer[])AsyncSenderImpl.this.buffer);
                for (long written = 0L; written < toWrite; written += res) {
                    res = AsyncSenderImpl.this.streamSinkChannel.write(AsyncSenderImpl.this.buffer, 0, AsyncSenderImpl.this.buffer.length);
                    if (res != 0L) continue;
                    return;
                }
                AsyncSenderImpl.this.streamSinkChannel.suspendWrites();
                AsyncSenderImpl.this.invokeOnComplete();
            }
            catch (IOException e) {
                AsyncSenderImpl.this.streamSinkChannel.suspendWrites();
                AsyncSenderImpl.this.callback.onException(AsyncSenderImpl.this.exchange, AsyncSenderImpl.this, e);
            }
        }
    };

    public AsyncSenderImpl(StreamSinkChannel streamSinkChannel, HttpServerExchange exchange) {
        this.streamSinkChannel = streamSinkChannel;
        this.exchange = exchange;
    }

    @Override
    public void send(ByteBuffer buffer, IoCallback callback) {
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (this.buffer != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        this.callback = callback;
        if (this.inCallback) {
            this.buffer = new ByteBuffer[]{buffer};
            return;
        }
        try {
            do {
                if (buffer.remaining() == 0) {
                    callback.onComplete(this.exchange, this);
                    return;
                }
                int res = this.streamSinkChannel.write(buffer);
                if (res != 0) continue;
                this.buffer = new ByteBuffer[]{buffer};
                this.callback = callback;
                this.streamSinkChannel.getWriteSetter().set(this.writeListener);
                this.streamSinkChannel.resumeWrites();
                return;
            } while (buffer.hasRemaining());
            this.invokeOnComplete();
        }
        catch (IOException e) {
            callback.onException(this.exchange, this, e);
        }
    }

    @Override
    public void send(ByteBuffer[] buffer, IoCallback callback) {
        long t;
        if (callback == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("callback");
        }
        if (this.buffer != null) {
            throw UndertowMessages.MESSAGES.dataAlreadyQueued();
        }
        this.callback = callback;
        if (this.inCallback) {
            this.buffer = buffer;
            return;
        }
        long total = t = Buffers.remaining((Buffer[])buffer);
        long written = 0L;
        try {
            do {
                long res = this.streamSinkChannel.write(buffer);
                written += res;
                if (res != 0L) continue;
                this.buffer = buffer;
                this.callback = callback;
                this.streamSinkChannel.getWriteSetter().set(this.writeListener);
                this.streamSinkChannel.resumeWrites();
                return;
            } while (written < total);
            this.invokeOnComplete();
        }
        catch (IOException e) {
            callback.onException(this.exchange, this, e);
        }
    }

    @Override
    public void send(String data, IoCallback callback) {
        this.send(ByteBuffer.wrap(data.getBytes(utf8)), callback);
    }

    @Override
    public void send(String data, Charset charset, IoCallback callback) {
        this.send(ByteBuffer.wrap(data.getBytes(charset)), callback);
    }

    @Override
    public void close(final IoCallback callback) {
        block5: {
            try {
                this.streamSinkChannel.shutdownWrites();
                if (!this.streamSinkChannel.flush()) {
                    this.streamSinkChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener((ChannelListener)new ChannelListener<StreamSinkChannel>(){

                        public void handleEvent(StreamSinkChannel channel) {
                            callback.onComplete(AsyncSenderImpl.this.exchange, AsyncSenderImpl.this);
                        }
                    }, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSinkChannel>(){

                        public void handleException(StreamSinkChannel channel, IOException exception) {
                            callback.onException(AsyncSenderImpl.this.exchange, AsyncSenderImpl.this, exception);
                        }
                    }));
                    this.streamSinkChannel.resumeWrites();
                } else if (callback != null) {
                    callback.onComplete(this.exchange, this);
                }
            }
            catch (IOException e) {
                if (callback == null) break block5;
                callback.onException(this.exchange, this, e);
            }
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOnComplete() {
        while (true) {
            long t;
            IoCallback callback = this.callback;
            this.buffer = null;
            this.callback = null;
            this.inCallback = true;
            try {
                callback.onComplete(this.exchange, this);
            }
            finally {
                this.inCallback = false;
            }
            if (this.buffer == null) break;
            long total = t = Buffers.remaining((Buffer[])this.buffer);
            long written = 0L;
            try {
                do {
                    long res = this.streamSinkChannel.write(this.buffer);
                    written += res;
                    if (res != 0L) continue;
                    this.streamSinkChannel.getWriteSetter().set(this.writeListener);
                    this.streamSinkChannel.resumeWrites();
                    return;
                } while (written < total);
            }
            catch (IOException e) {
                callback.onException(this.exchange, this, e);
            }
        }
    }
}

