/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.PathMatchPredicate;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateParser;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import org.junit.Assert;
import org.junit.Test;

public class PredicateParsingTestCase {
    @Test
    public void testPredicateParser() {
        Predicate predicate = PredicateParser.parse((String)"path[foo]");
        Assert.assertTrue((boolean)(predicate instanceof PathMatchPredicate));
        HttpServerExchange e = new HttpServerExchange(null);
        e.setRelativePath("foo");
        Assert.assertTrue((boolean)predicate.resolve(e));
        e.setRelativePath("bob");
        Assert.assertFalse((boolean)predicate.resolve(e));
        for (String string : new String[]{"not path[\"/foo\"]", "not path[foo] and true", "false or not path[path=/foo]", "false or not path[/foo]", "true and not path[foo] or not path[foo] and false"}) {
            try {
                predicate = PredicateParser.parse((String)string);
                e = new HttpServerExchange(null);
                e.setRelativePath("foo");
                Assert.assertFalse((boolean)predicate.resolve(e));
                e.setRelativePath("bob");
                Assert.assertTrue((boolean)predicate.resolve(e));
            }
            catch (Throwable ex) {
                throw new RuntimeException("String " + string, ex);
            }
        }
    }

    @Test
    public void testArrayValues() {
        for (String string : new String[]{"hasRequestHeaders[Content-Length]", "hasRequestHeaders[{Content-Length}]", "hasRequestHeaders[headers={Content-Length}]", "hasRequestHeaders[headers={Content-Length, otherHeader, \"some more headers\"}, requireAllHeaders=false]"}) {
            try {
                Predicate predicate = PredicateParser.parse((String)string);
                HttpServerExchange e = new HttpServerExchange(null);
                Assert.assertFalse((boolean)predicate.resolve(e));
                e.getRequestHeaders().add(Headers.CONTENT_LENGTH, "a");
                Assert.assertTrue((boolean)predicate.resolve(e));
            }
            catch (Throwable ex) {
                throw new RuntimeException("String " + string, ex);
            }
        }
    }

    @Test
    public void testOrderOfOperations() {
        this.expect("hasRequestHeaders[Content-Length] or hasRequestHeaders[headers=Trailer] and hasRequestHeaders[Other]", false, true);
        this.expect("(hasRequestHeaders[Content-Length] or hasRequestHeaders[headers=Trailer]) and hasRequestHeaders[Other]", false, false);
    }

    private void expect(String string, boolean result1, boolean result2) {
        try {
            Predicate predicate = PredicateParser.parse((String)string);
            HttpServerExchange e = new HttpServerExchange(null);
            e.getRequestHeaders().add(Headers.TRAILER, "a");
            Assert.assertEquals((Object)result1, (Object)predicate.resolve(e));
            e.getRequestHeaders().add(Headers.CONTENT_LENGTH, "a");
            Assert.assertEquals((Object)result2, (Object)predicate.resolve(e));
        }
        catch (Throwable ex) {
            throw new RuntimeException("String " + string, ex);
        }
    }
}

