/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.test;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.test.utils.AjpIgnore;
import io.undertow.test.utils.DefaultServer;
import io.undertow.util.StringWriteChannelListener;
import io.undertow.util.TestHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Options;
import org.xnio.channels.ReadTimeoutException;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

@RunWith(value=DefaultServer.class)
@AjpIgnore
@Ignore
public class ReadTimeoutTestCase {
    private volatile Exception exception;
    private static final CountDownLatch errorLatch = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadTimeout() throws IOException, InterruptedException {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(final HttpServerExchange exchange) throws Exception {
                final StreamSinkChannel response = exchange.getResponseChannel();
                StreamSourceChannel request = exchange.getRequestChannel();
                try {
                    request.setOption(Options.READ_TIMEOUT, (Object)100);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                request.getReadSetter().set(ChannelListeners.drainListener((long)Long.MAX_VALUE, (ChannelListener)new ChannelListener<Channel>(){

                    public void handleEvent(Channel channel) {
                        new StringWriteChannelListener("COMPLETED"){

                            protected void writeDone(StreamSinkChannel channel) {
                                exchange.endExchange();
                            }
                        }.setup(response);
                    }
                }, (ChannelExceptionHandler)new ChannelExceptionHandler<StreamSourceChannel>(){

                    public void handleException(StreamSourceChannel channel, IOException e) {
                        exchange.endExchange();
                        ReadTimeoutTestCase.this.exception = e;
                        errorLatch.countDown();
                    }
                }));
                request.wakeupReads();
            }
        });
        TestHttpClient client = new TestHttpClient();
        try {
            HttpPost post = new HttpPost(DefaultServer.getDefaultServerURL());
            post.setEntity((HttpEntity)new AbstractHttpEntity(){

                public InputStream getContent() throws IOException, IllegalStateException {
                    return null;
                }

                public void writeTo(OutputStream outstream) throws IOException {
                    for (int i = 0; i < 5; ++i) {
                        outstream.write(42);
                        outstream.flush();
                        try {
                            Thread.sleep(200L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }

                public boolean isStreaming() {
                    return true;
                }

                public boolean isRepeatable() {
                    return false;
                }

                public long getContentLength() {
                    return 5L;
                }
            });
            post.addHeader("Connection", "close");
            try {
                client.execute((HttpUriRequest)post);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (errorLatch.await(5L, TimeUnit.SECONDS)) {
                Assert.assertEquals(ReadTimeoutException.class, this.exception.getClass());
            } else {
                Assert.fail((String)"Read did not time out");
            }
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

