/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.test.handlers.caching;

import io.undertow.io.IoCallback;
import io.undertow.predicate.Predicate;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.cache.CacheHandler;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.cache.ResponseCache;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.DeflateEncodingProvider;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.test.utils.DefaultServer;
import io.undertow.test.utils.HttpClientUtils;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.ContentEncodingHttpClient;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DefaultServer.class)
public class CacheHandlerContentEncodingTestCase {
    private static final AtomicInteger responseCount = new AtomicInteger();
    public static final HttpString ACTUALLY_DEFLATE = new HttpString("ActuallyDeflate");

    @BeforeClass
    public static void setup() {
        HttpHandler messageHandler = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                ResponseCache cache = (ResponseCache)exchange.getAttachment(ResponseCache.ATTACHMENT_KEY);
                if (!cache.tryServeResponse()) {
                    String data = "Response " + responseCount.incrementAndGet();
                    exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, data.length() + "");
                    exchange.getResponseSender().send(data, IoCallback.END_EXCHANGE);
                }
            }
        };
        CacheHandler cacheHandler = new CacheHandler(new DirectBufferCache(100, 10, 10000), messageHandler);
        EncodingHandler handler = new EncodingHandler((HttpHandler)cacheHandler);
        handler.addEncodingHandler("deflate", (ContentEncodingProvider)new DeflateEncodingProvider(), 50, new Predicate(){

            public boolean resolve(HttpServerExchange value) {
                return value.getRequestHeaders().contains(ACTUALLY_DEFLATE);
            }
        });
        DefaultServer.setRootHandler((HttpHandler)handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCachingWithContentEncoding() throws IOException {
        ContentEncodingHttpClient client = new ContentEncodingHttpClient();
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            for (int i = 1; i <= 5; ++i) {
                HttpResponse result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                Assert.assertEquals((Object)("Response " + i), (Object)HttpClientUtils.readResponse(result));
                Header[] header = result.getHeaders("Content-Encoding");
                Assert.assertEquals((long)0L, (long)header.length);
            }
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Response 5", (Object)HttpClientUtils.readResponse(result));
            Header[] header = result.getHeaders("Content-Encoding");
            Assert.assertEquals((long)0L, (long)header.length);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Response 5", (Object)HttpClientUtils.readResponse(result));
            header = result.getHeaders("Content-Encoding");
            Assert.assertEquals((long)0L, (long)header.length);
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Response 5", (Object)HttpClientUtils.readResponse(result));
            header = result.getHeaders("Content-Encoding");
            Assert.assertEquals((long)0L, (long)header.length);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path2");
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Assert.assertEquals((Object)"Response 6", (Object)HttpClientUtils.readResponse(result));
            header = result.getHeaders("Content-Encoding");
            Assert.assertEquals((long)0L, (long)header.length);
            get = new HttpGet(DefaultServer.getDefaultServerURL() + "/path");
            get.setHeader("ActuallyDeflate", "true");
            for (int i = 1; i <= 5; ++i) {
                result = client.execute((HttpUriRequest)get);
                Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
                header = result.getHeaders("Content-Encoding");
                Assert.assertEquals((Object)"deflate", (Object)header[0].getValue());
                Assert.assertEquals((Object)("Response " + (i + 6)), (Object)HttpClientUtils.readResponse(result));
            }
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders("Content-Encoding");
            Assert.assertEquals((Object)"deflate", (Object)header[0].getValue());
            Assert.assertEquals((Object)"Response 11", (Object)HttpClientUtils.readResponse(result));
            result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            header = result.getHeaders("Content-Encoding");
            Assert.assertEquals((Object)"deflate", (Object)header[0].getValue());
            Assert.assertEquals((Object)"Response 11", (Object)HttpClientUtils.readResponse(result));
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }
}

