/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.test.ssl;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.test.utils.AjpIgnore;
import io.undertow.test.utils.DefaultServer;
import io.undertow.util.HttpString;
import io.undertow.util.TestHttpClient;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@AjpIgnore
@RunWith(value=DefaultServer.class)
public class SimpleSSLTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void simpleSSLTestCase() throws IOException, GeneralSecurityException {
        DefaultServer.setRootHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                exchange.getResponseHeaders().put(HttpString.tryFromString((String)"scheme"), exchange.getRequestScheme());
                exchange.endExchange();
            }
        });
        DefaultServer.startSSLServer();
        TestHttpClient client = new TestHttpClient();
        client.setSSLContext(DefaultServer.getClientSSLContext());
        try {
            HttpGet get = new HttpGet(DefaultServer.getDefaultServerSSLAddress());
            HttpResponse result = client.execute((HttpUriRequest)get);
            Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
            Header[] header = result.getHeaders("scheme");
            Assert.assertEquals((Object)"https", (Object)header[0].getValue());
        }
        finally {
            client.getConnectionManager().shutdown();
            DefaultServer.stopSSLServer();
        }
    }
}

